package it.unicam.cs.asdl1819.mylist;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/**
 * Lista concatenata doppia che non accetta valori null, ma permette elementi
 * duplicati.
 * 
 * @author luca
 *
 * @param <E>
 *            il tipo degli elementi della lista
 */
public class MyList<E> implements List<E> {

    private int size;

    private Nodo head;

    private Nodo tail;

    /**
     * Crea una lista vuota.
     */
    public MyList() {
        this.size = 0;
        this.head = null;
        this.tail = null;
    }

    /**
     * Crea un lista con un solo elemento.
     * 
     * @param el
     *               l'elemento della lista
     */
    public MyList(E el) {
        this.size = 1;
        this.head = new Nodo(el);
        this.tail = this.head;

    }

    /*
     * Classe per i nodi della lista concatenata doppia
     */
    private class Nodo {
        private E el;

        private Nodo next;

        private Nodo previous;

        /*
         * Crea un nodo "singolo" equivalente a una lista con un solo elemento.
         */
        Nodo(E el) {
            this.el = el;
            this.next = null;
            this.previous = null;
        }
    }

    /*
     * Classe che realizza un iteratore (con remove) per MyList
     */
    private class Itr implements Iterator<E> {

        private Nodo cursore;

        private boolean removeGiaFatto;

        private Itr() {
            // All'inizio il cursore è null
            this.cursore = null;
            this.removeGiaFatto = false;
        }

        @Override
        public boolean hasNext() {
            // caso iniziale
            if (this.cursore == null)
                if (MyList.this.isEmpty())
                    // non c'è il prossimo elemento
                    return false;
                else
                    return true;
            // caso non iniziale
            // accedo al campo next dell'elemento puntato dal cursore
            if (this.cursore.next == null)
                // la lista è finita
                return false;
            else
                return true;
        }

        @Override
        public E next() {
            if (!this.hasNext())
                throw new NoSuchElementException(
                        "Tentativo di ottenere il prossimo elemento che non esiste");
            // esiste un prossimo elemento
            Nodo prossimo = this.cursore.next;
            // aggiorno il cursore
            this.cursore = prossimo;
            this.removeGiaFatto = false;
            return prossimo.el;
        }

        @Override
        public void remove() {
            // ho già fatto il remove per questo next
            if (this.removeGiaFatto)
                throw new IllegalStateException("Doppia richiesta di remove");
            // non ho mai fatto next
            if (this.cursore == null)
                throw new IllegalStateException(
                        "Richiesta di remove senza aver fatto mai next");
            // rimuovo l'elmento puntato dal cursore
            // caso 1: rimozione del primo elemento
            if (MyList.this.head == this.cursore) {
                // aggiorno la testa della lista
                MyList.this.head = this.cursore.next;
                // controllo se il prossimo elemento esiste
                if (this.cursore.next == null) {
                    // il primo elemento era anche l'ultimo
                    // cambio pure la coda della lista
                    MyList.this.tail = null;
                    MyList.this.size = 0;
                } else {
                    // il primo elemento non era l'ultimo
                    // scollego il collegamento a previuos del nuovo nodo
                    // iniziale
                    this.cursore.next.previous = null;
                    MyList.this.size--;
                }
                this.cursore = null;
            } else {
                // caso 2: rimozione di un elemento successivo al primo
                // quindi this.cursore.previous esiste
                // controllo se il prossimo elemento esiste
                if (this.cursore.next == null) {
                    // questo elemento è anche l'ultimo
                    // cambio pure la coda della lista
                    MyList.this.tail = this.cursore.previous;
                    // scollego questo elemento
                    this.cursore.previous.next = null;
                    // aggiorno il cursore
                    this.cursore = this.cursore.previous;
                } else {
                    // questo elemento non è l'ultimo, quindi esiste il next
                    // collego l'elemento precedente al cursore con il
                    // successivo al cursore
                    this.cursore.previous.next = this.cursore.next;
                    // collego l'elemento successivo al cursore con l'elemento
                    // precedente al cursore
                    this.cursore.next.previous = this.cursore.previous;
                    // aggiorno il cursore
                    this.cursore = this.cursore.previous;
                }
                // ho cancellato un elemento e aggiorno la size
                MyList.this.size--;
            }
            // aggiorno il flag di remove già fatto
            this.removeGiaFatto = true;
        }

    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null)
            throw new NullPointerException("Oggetto da cercare nullo!");
        // Ricerca lineare a partire dalla head della lista
        Nodo iPointer = this.head;
        boolean trovato = false;
        while (!trovato && iPointer != null) {
            if (o.equals(iPointer.el))
                trovato = true;
            else
                iPointer = iPointer.next;
        }
        if (trovato)
            return true;
        else
            return false; // equivalente a return trovato;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public Object[] toArray() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean add(E e) {
        if (e == null)
            throw new NullPointerException(
                    "Tentativo di inserire un elemento null");
        // Creo un nuovo nodo singolo che contiene l'elemento da inserire
        Nodo n = new Nodo(e);
        // aggiorno il next dell'ultimo elemento corrente
        this.tail.next = n;
        // creo il collegamento del nuovo nodo al precedente
        n.previous = this.tail;
        // aggiorno il puntatore alla coda della lista
        this.tail = n;
        // aggioro la size della lista
        this.size++;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c == null)
            throw new NullPointerException(
                    "Tentativo di aggiungere elementi da una collezione null");
        for (Object o : c) {
            if (o == null)
                throw new NullPointerException(
                        "Tentativo di aggiungere un elemento null");
            // non lancio l'eccezione ClassCastException perché uso il metodo
            // contains che accetta comunque qualsiasi oggetto
            if (!this.contains(o))
                return false;
        }
        // tutti gli oggetti della collection appartenevano a questa lista
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public void clear() {
        // TODO Auto-generated method stub

    }

    @Override
    public E get(int index) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public E set(int index, E element) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void add(int index, E element) {
        // controlli con eccezioni
        if (element == null)
            throw new NullPointerException(
                    "Tentativo di inserire un elemento null");
        if (index < 0 || index >= this.size)
            throw new IndexOutOfBoundsException(
                    "Tentativo di accesso alla posizione " + index
                            + " che non esiste nella lista attuale");
        // il caso particolare della lista vuota non è trattato
        // trattiamo il caso di inserimento in testa, cioè index == 0
        if (index == 0) {
            // creo il nuovo nodo
            Nodo n = new Nodo(element);
            // collego il nuovo nodo con il suo successore (ex testa)
            n.next = this.head;
            // collego il vecchio nodo di testa con il suo predecessore (il
            // nuovo nodo)
            this.head.previous = n;
            // aggiorno la testa
            this.head = n;
            // aggiorno la size
            this.size++;
            // esco
            return;
        }
        // decidiamo se partire dalla testa o dalla coda per trovare il
        // puntatore all'elemento in posizione index
        int middle = this.size / 2;
        // inizializzo la variabile risultato
        Nodo scanPointer = null;
        int scanner;
        if (index <= middle) {
            // parto dalla testa
            scanPointer = this.head;
            scanner = 0;
            for (; scanner < index; scanner++)
                scanPointer = scanPointer.next;

        } else {
            // parto dalla coda
            scanPointer = this.tail;
            scanner = this.size - 1;
            for (; scanner > index; scanner--)
                scanPointer = scanPointer.previous;
        }
        // scanPointer punta all'elemento corrente in posizione index
        // creo il puntatore al nodo che viene prima del nuovo nodo da inserire
        Nodo prevPointer = scanPointer.previous;
        // creo il nuovo nodo
        Nodo n = new Nodo(element);
        // collego il nodo precedente (posizione index - 1) al nodo n (nuova
        // posizione index)
        prevPointer.next = n;
        // collego il nuovo nodo con il suo predecessore
        n.previous = prevPointer;
        // collego il nuovo nodo con il suo successore
        n.next = scanPointer;
        // collego il nodo spostato verso sinistra con il suo nuovo predecessore
        // che è il nuovo nodo
        scanPointer.previous = n;
        // aggiorno la size
        this.size++;
    }

    @Override
    public E remove(int index) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null)
            throw new NullPointerException("Oggetto da cercare nullo!");
        // Ricerca lineare a partire dalla head della lista
        Nodo iPointer = this.head;
        int i = -1;
        boolean trovato = false;
        while (!trovato && iPointer != null) {
            i++;
            if (o.equals(iPointer.el))
                trovato = true;
            else
                iPointer = iPointer.next;
        }
        if (trovato)
            return i;
        else
            return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public ListIterator<E> listIterator() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        // TODO Auto-generated method stub
        return null;
    }

}
