package it.unicam.cs.asdl1819.graphs;

import java.util.ArrayList;
import java.util.Set;

public class BFSVisitor<V, E> {

    /**
     * Esegue la visita in ampiezza di un certo grafo. Setta i valori seguenti
     * valori associati ai nodi: distanza intera, predecessore. La distanza
     * indica il numero minimo di archi che si devono percorrere dal nodo
     * sorgente per raggiungere il nodo e il predecessore rappresenta il padre
     * del nodo in un albero di copertura del grafo.
     * 
     * @param g
     *              il grafo da visitare.
     * @param source
     *              il nodo sorgente.
     */
    public void BFSVisit(Graph<V, E> g, GraphNode<V> source) {
       // controlli vari su null ed esistenza
        
       // TODO
        
       // Inizializzazione delle distanze, del colore e del predecessore
        for(GraphNode<V> n: g.getNodes()) {
            n.setColor(GraphNode.COLOR_WHITE);
            n.setIntegerDistance(0);
            n.setPrevious(null);
        }
        // Come coda utilizziamo una semplice arraylist
        ArrayList<GraphNode<V>> coda = new ArrayList<GraphNode<V>>();
        // Metto la sorgente in coda e la "visito"
        coda.add(source);
        source.setColor(GraphNode.COLOR_GREY);
        while (!coda.isEmpty()) {
            // tiro fuori il primo elemento in coda
            GraphNode<V> nodoCorrente = coda.remove(0);
            // Esploro i vicini del nodo corrente
            Set<GraphNode<V>> vicini = g.getAdjacentNodes(nodoCorrente);
            // Aggiorno i nodi bianci e li metto in coda
            for (GraphNode<V> n : vicini) {
                if (n.getColor() == GraphNode.COLOR_WHITE) {
                    n.setIntegerDistance(nodoCorrente.getIntegerDistance() + 1);
                    n.setPrevious(nodoCorrente);
                    n.setColor(GraphNode.COLOR_GREY);
                    coda.add(n);
                }
            // metto il nodo corrente a nero
                nodoCorrente.setColor(GraphNode.COLOR_BLACK);     
            }
        }
    }
    
    // TODO Testare
    
    // TODO Inserire altri metodi per analizzare i risultati
    
    // TODO Definire dei test JUnit per controllare la correttezza
    

}
