package it.unicam.cs.asdl1819.bankaccounts;

import java.util.ArrayList;
import java.util.List;

/**
 * Banca la cui collezione dei conti è gestita attraverso una lista. 
 * 
 * @author Luca Tesei
 *
 */
public class Bank {
    private final String swiftCode;

    private String name;

    private String address;

    private List<BankAccount> conti;

    /**
     * @param swiftCode
     *                      codice identificativo della banca
     * @param name
     *                      nome della banca
     * @param address
     *                      indirizzo
     */
    public Bank(String swiftCode, String name, String address) {
        this.swiftCode = swiftCode;
        this.name = name;
        this.address = address;
        this.conti = new ArrayList<BankAccount>();
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * @param name
     *                 the name to set
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return the address
     */
    public String getAddress() {
        return address;
    }

    /**
     * @param address
     *                    the address to set
     */
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * @return the swiftCode
     */
    public String getSwiftCode() {
        return swiftCode;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result
                + ((swiftCode == null) ? 0 : swiftCode.hashCode());
        return result;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof Bank))
            return false;
        Bank other = (Bank) obj;
        if (swiftCode == null) {
            if (other.swiftCode != null)
                return false;
        } else if (!swiftCode.equals(other.swiftCode))
            return false;
        return true;
    }

    /**
     * Inserisce un nuovo conto.
     * 
     * @param b
     *              il nuovo conto
     * @throws IllegalArgumentException
     *                                      se il conto è già esistente in
     *                                      questa banca
     */
    public void add(BankAccount b) {
        // Controlla che il conto non è già stato inserito
        if (this.conti.contains(b)) // si basa su equals di BankAccount!
            throw new IllegalArgumentException(
                    "Inserimento di conto già esistente");
        // inserisco il conto
        this.conti.add(b);
    }

    /**
     * Esegue le procedure di fine mese su tutti i conti.
     */
    public void endOfMonth() {
        // chiamo il metodo su tutti i conti
        for (int i = 0; i < this.conti.size(); i++)
            this.conti.get(i).endOfMonth();
    }

    /**
     * Cerca se un conto è già presente
     * 
     * @param b
     *              un conto
     * @return true se il conto esiste già, false altrimenti
     */
    public boolean search(BankAccount b) {
        // Ricerco il conto nell'array
        return this.conti.contains(b); // Si basa su equals di BankAccount per
                                       // selezione posticipata
    }

    /**
     * Cerca l'indice di un conto nella lista dei conti.
     * 
     * @param b
     *              un conto
     * @return la posizione del conto nella lista dei conti, -1 se il conto non
     *         esiste.
     */
    public int indexOf(BankAccount b) {
        // Ricerco il conto nell'array
        return this.conti.indexOf(b); // Si basa su equals di BankAccount per
        // selezione posticipata
    }

    /**
     * Rimuove un certo conto.
     * 
     * @param b
     *              il conto da rimuovere
     * @return true se il conto è stato rimosso, false altrimenti
     */
    public boolean remove(BankAccount b) {
        return this.conti.remove(b); // Si basa su equals di BankAccount per 
        // selezione posticipata
    }
}
