/**
 * 
 */
package it.unicam.cs.asdl1819.bankaccounts;

/**
 * Un particolare conto di risparmio vincolato con un tasso aggiuntivo sui mesi
 * in cui l'importo è vincolato
 * 
 * @author luca
 *
 */
public class TimedAccount extends SavingsAccount {
    private int numeroMesiVincolo;

    private int mesiRimanenti;

    private double tassoAggiuntivo;

    /**
     * @param saldo
     * @param nome
     * @param iban
     */
    public TimedAccount(double saldo, String nome, String iban) {
        super(saldo, nome, iban);
        this.numeroMesiVincolo = 18;
        this.mesiRimanenti = 18;
        this.tassoAggiuntivo = 3.0;
    }

    /**
     * @param saldo
     * @param nome
     * @param iban
     * @param tassoDiInteresse
     */
    public TimedAccount(double saldo, String nome, String iban,
            double tassoDiInteresse) {
        super(saldo, nome, iban, tassoDiInteresse);
        this.numeroMesiVincolo = 18;
        this.mesiRimanenti = 18;
        this.tassoAggiuntivo = 3.0;
    }

    /**
     * @param saldo
     * @param nome
     * @param iban
     * @param numeroMesiVincolo
     * @param tassoAggiuntivo
     */
    public TimedAccount(double saldo, String nome, String iban,
            int numeroMesiVincolo, double tassoAggiuntivo) {
        super(saldo, nome, iban);
        this.numeroMesiVincolo = numeroMesiVincolo;
        this.tassoAggiuntivo = tassoAggiuntivo;
        this.mesiRimanenti = numeroMesiVincolo;
    }

    public void withdraw(double importo) {
        super.withdraw(importo);
        if (this.mesiRimanenti > 0)
            // Rotto il vincolo, riparte il conteggio dei mesi 
            this.mesiRimanenti = this.numeroMesiVincolo;
    }

    /*
     * (non-Javadoc)
     * 
     * @see it.unicam.cs.asdl1617.bankaccounts.SavingsAccount#endOfMonth()
     */
    @Override
    public void endOfMonth() {
        super.endOfMonth();
        if (this.mesiRimanenti > 1)
            this.mesiRimanenti--;
        else if (this.mesiRimanenti == 1) {
            // calcolo interesse aggiuntivo
            // Attenzione, calcolo errato
            double interesse = this.getSaldo() * this.tassoAggiuntivo / 100;
            super.deposit(interesse);
            this.mesiRimanenti = 0;
        }
    }

}
