package it.unicam.cs.asdl1819.dataset;

/**
 * Un conto bancario ha un saldo che pu&ograve; essere modificato da depositi e
 * prelievi
 */
public class BankAccount implements Measurable {

    // Variabile istanza
    private double saldo;

    /**
     * Costruisce un conto bancario con saldo uguale a zero
     */
    public BankAccount() {
        saldo = 0.0;
    }

    /**
     * Restituisce la misura associata a questo conto, cioè il saldo.
     */
    public double getMeasure() {
        return saldo;
    }

    /**
     * Costruisce un conto bancario con un saldo assegnato
     * 
     * @param initialBalance
     *                           il saldo iniziale
     */
    public BankAccount(double initialBalance) {
        saldo = initialBalance;
    }

    /**
     * Versa denaro nel conto bancario
     * 
     * @param amount
     *                   l'importo da versare
     */
    public void deposit(double amount) {
        saldo = saldo + amount;
    }

    /**
     * Preleva denaro dal conto bancario
     * 
     * @param amount
     *                   l'importo da prelevare
     */
    public void withdraw(double amount) {
        saldo = saldo - amount;
    }

    /**
     * Ispeziona il valore del saldo attuale del conto bancario
     * 
     * @return il saldo attuale
     */
    public double getBalance() {
        return saldo;
    }

}
