package it.unicam.cs.asdl1819.dataset;

/**
 * Calcola la media e il massimo di un insieme di oggetti usando un oggetto
 * misuratore
 */
public class DataSetStrat {
    // variabili istanza
    private Measurer measurer;

    private double sum;

    private int count;

    private Object maximum;

    /**
     * Inizializza le variabili istanza con valori relativi ad un insieme di
     * dati vuoto e riceve un misuratore di oggetti
     * 
     * @param aMeasurer
     *            un misuratore che implementa una certa strategia
     */
    public DataSetStrat(Measurer aMeasurer) {
        measurer = aMeasurer;
        sum = 0;
        maximum = null;
        count = 0;
    }

    /**
     * Aggiunge un oggetto all'insieme di dati
     * 
     * @param x
     *            un oggetto di una classe misurabile dal misuratore
     */
    public void add(Object x) {
        sum += measurer.measure(x);
        if (count == 0 || measurer.measure(maximum) < measurer.measure(x))
            maximum = x;
        count++;
    }

    /**
     * Restituisce la media delle misure degli oggetti inseriti
     * 
     * @return la media, oppure 0 se non sono stati inseriti oggetti
     */
    public double getAverage() {
        if (count == 0)
            return 0;
        else
            return sum / count;
    }

    /**
     * Restituisce l'oggetto la cui misura Ë massima rispetto a tutti gli
     * oggetti inseriti
     * 
     * @return l'oggetto con misura massima o null se non sono stati inseriti
     *         oggetti
     */
    public Object getMaximum() {
        return maximum;
    }

}
