package it.unicam.cs.asdl1819.dataset;

import java.awt.Rectangle;

/**
 * Testa la classe DataSetStrat che utilizza l'interfaccia strategica Measurer
 */
public class DataSetStratTest {

    public static void main(String argv[]) {
        // Definisco il misuratore come classe interna
        class RectangleMeasurer implements Measurer {
            public double measure(Object anObject) {
                Rectangle aRectangle = (Rectangle) anObject;
                double area = aRectangle.getHeight() * aRectangle.getWidth();
                return area;
            }
        }
        // Creo il DataSet
        RectangleMeasurer m = new RectangleMeasurer();
        DataSetStrat data = new DataSetStrat(m);
        // inserisco alcuni rettangoli
        data.add(new Rectangle(0, 4, 20, 12));
        data.add(new Rectangle(0, 2, 15, 15));
        data.add(new Rectangle(0, 0, 10, 20));
        // Chiedo media e massimo
        System.out.println("Media delle aree: " + data.getAverage());
        System.out
                .println("Rettangolo con area maggiore: " + data.getMaximum());
    }
}
