/**
 * 
 */
package it.unicam.cs.asdl1819.bankaccounts;

/**
 * Un conto corrente con spese fisse per ogni operazione effettuata
 * @author luca
 *
 */
public class CheckingAccount extends BankAccount {

    private int numeroOperazioni;
    private double costoPerOperazione;
    
    /**
     * @param saldo
     * @param nome
     * @param iban
     */
    public CheckingAccount(double saldo, String nome, String iban) {
        super(saldo, nome, iban);
        this.costoPerOperazione = 1.0;
        this.numeroOperazioni = 0;
    }

 /**
     * @param saldo
     * @param nome
     * @param iban
     * @param costoPerOperazione
     */
    public CheckingAccount(double saldo, String nome, String iban,
            double costoPerOperazione) {
        super(saldo, nome, iban);
        this.costoPerOperazione = costoPerOperazione;
        this.numeroOperazioni = 0;
    }

   /* (non-Javadoc)
     * @see it.unicam.cs.asdl1617.bankaccounts.BankAccount#endOfMonth()
     */
    @Override
    public void endOfMonth() {
        double costo = this.numeroOperazioni * this.costoPerOperazione;
        System.out.println("Costo " + costo);
        if (this.getSaldo() < costo)
            throw new InsufficientFundForCostException("SaldoInsufficiente per pagare le spese di operazione");
        super.withdraw(costo);
        this.numeroOperazioni = 0;
    }

    public void deposit(double importo){
        super.deposit(importo);
        this.numeroOperazioni++;
    }
    
    public void withdraw(double importo){
        super.withdraw(importo);
        this.numeroOperazioni++;
    }
    
    
}
