/**
 * 
 */
package it.unicam.cs.asdl1819.bankaccounts;

/**
 * Un conto di risparmio con un tasso di interesse
 * @author luca
 *
 */
public class SavingsAccount extends BankAccount {
     private double tassoDiInteresse;
     
    /**
     * @param saldo
     * @param nome
     * @param iban
     */
    public SavingsAccount(double saldo, String nome, String iban) {
        super(saldo, nome, iban);
        this.tassoDiInteresse = 1.0;
    }

   /**
     * @param saldo
     * @param nome
     * @param iban
     * @param tassoDiInteresse
     */
    public SavingsAccount(double saldo, String nome, String iban,
            double tassoDiInteresse) {
        super(saldo, nome, iban);
        this.tassoDiInteresse = tassoDiInteresse;
    }

 /* (non-Javadoc)
     * @see it.unicam.cs.asdl1617.bankaccounts.BankAccount#endOfMonth()
     */
    @Override
    public void endOfMonth() {
        // TODO Auto-generated method stub
       // ATTENZIONE CONTO SBAGLIATO
        double interesse = getSaldo() * tassoDiInteresse / 100;
        super.deposit(interesse);
    }

}
