package it.unicam.cs.asdl1819.dataset;

/**
 * Un oggetto di questa classe rappresenta una moneta con il suo valore
 */
public class CoinSimple {
    private double value;

    private String name;

    public CoinSimple(double aValue, String aName) {
        value = aValue;
        name = aName;
    }

    public double getValue() {
        return value;
    }

    public String getDescription() {
        return name;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((name == null) ? 0 : name.hashCode());
        long temp;
        temp = Double.doubleToLongBits(value);
        result = prime * result + (int) (temp ^ (temp >>> 32));
        return result;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof CoinSimple))
            return false;
        CoinSimple other = (CoinSimple) obj;
        if (name == null) {
            if (other.name != null)
                return false;
        } else if (!name.equals(other.name))
            return false;
        if (Double.doubleToLongBits(value) != Double
                .doubleToLongBits(other.value))
            return false;
        return true;
    }



}
