package it.unicam.cs.asdl1819.adtlists;

/**
 * Classe che implementa ADTList<E> con due campi immutabili.
 * 
 * @author Luca Tesei
 *
 * @param <E>
 *            il tipo degli elementi della lista.
 */
public final class ConsList<E> implements ADTList<E> {
    private final E head;

    private final ADTList<E> tail;

    /**
     * Costruisce una lista a partire dalla lista vuota inserendo in testa un
     * elemento.
     * 
     * @param head
     *                 l'elemento da inserire nella lista.
     */
    @SuppressWarnings("unchecked")
    public ConsList(E head) {
        this.head = head;
        this.tail = ADTList.EMPTY_LIST;
    }

    /**
     * Costruisce una lista a partire da una ADTList<E> e inserendo in testa un
     * nuovo elemento.
     * 
     * @param head l'elemento in testa
     * @param tail la lista di partenza
     */
    public ConsList(E head, ADTList<E> tail) {
        this.head = head;
        this.tail = tail;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public E head() {
        return this.head;
    }

    @Override
    public ADTList<E> tail() {
        return this.tail;
    }

    @Override
    public ADTList<E> cons(E head) {
        return new ConsList<E>(head, this);
    }

}
