package it.unicam.cs.asdl1819.adtlists;

/**
 * Classe che definisce solo una ADTList vuota.
 * 
 * @author Luca Tesei
 *
 * @param <E> non significativo per la lista vuota
 */
public final class EmptyADTList<E> implements ADTList<E> {

    public boolean isEmpty() {
        return true;
    }

    public E head() {
        throw new IllegalStateException(
                "Tentativo di accedere alla testa di una lista vuota");
    }

    public ADTList<E> tail() {
        throw new IllegalStateException(
                "Tentativo di accedere alla coda di una lista vuota");
    }

    public ADTList<E> cons(E head) {
        return new ConsList<E>(head);
    }

}
