/**
 * 
 */
package it.unicam.cs.asdl1819.queens;

import java.util.List;
import java.util.ArrayList;

/**
 * @author luca
 *
 */
public class AllSolutionsEightQueensSolver implements EightQueensSolver {

    // Scacchiera privata di questo solver
    private Scacchiera s;

    private ArrayList<ArrayList<PositionedQueen>> soluzioni;

    private int contatore;

    private boolean firstSolutionRichiesta;

    /**
     * Crea un nuovo solver
     */
    public AllSolutionsEightQueensSolver() {
        s = new Scacchiera();
        soluzioni = new ArrayList<ArrayList<PositionedQueen>>();
        contatore = 0;
        firstSolutionRichiesta = false;
        findAll(0, new ArrayList<PositionedQueen>());
    }

    /*
     * (non-Javadoc)
     * 
     * @see it.unicam.cs.asdl1819.queens.EightQueensSolver#firstSolution()
     */
    @Override
    public List<PositionedQueen> firstSolution() {
        if (contatore > 0)
            throw new IllegalStateException("Prima soluzione già richiesta");
        contatore++;
        return this.soluzioni.get(0);    
    }

    /*
     * (non-Javadoc)
     * 
     * @see it.unicam.cs.asdl1819.queens.EightQueensSolver#nextSolution()
     */
    @Override
    public List<PositionedQueen> nextSolution() {
        if (contatore == this.soluzioni.size())
            return null;
        contatore++;
        return this.soluzioni.get(contatore - 1);
    }

    private void findAll(int col, ArrayList<PositionedQueen> singleSol) {
        if (col == 8) {
            // ho trovato una soluzione e la aggiungo alla lista delle soluzioni
            soluzioni.add((ArrayList<PositionedQueen>) singleSol.clone());
            return;
        }
        // cerco le soluzioni ricorsivamente
        for (int riga = 0; riga < 8; riga++) {
            if (s.isFree(riga, col)) {
                s.putQueen(riga, col);
                PositionedQueen regina = new PositionedQueen(riga, col);
                singleSol.add(regina);
                findAll(col + 1, singleSol);
                s.removeQueen(riga, col);
                singleSol.remove((Object) regina);
            }
        }
    }
}
