/**
 * 
 */
package it.unicam.cs.asdl1819.queens;

import java.util.List;

/**
 * Risolutore del problema delle 8 regine.
 * 
 * @author Luca Tesei
 *
 */
public interface EightQueensSolver {

    /**
     * Restituisce la prima soluzione trovata tramite la strategia di ricerca
     * con backtracking.
     * 
     * @return la prima soluzione sottoforma di lista di 8 regine posizionate
     *         nella scacchiera
     * 
     * @throws IllegalStateException
     *                                   se la prima soluzione è già stata
     *                                   ottenuta in precedenza
     */
    public List<PositionedQueen> firstSolution();

    /**
     * Restituisce la soluzione successiva all'ultima trovata tramite la
     * strategia di ricerca con backtracking.
     * 
     * @return la prossima soluzione sottoforma di lista di 8 regine posizionate
     *         nella scacchiera oppure null se non ci sono più soluzioni.
     */
    public List<PositionedQueen> nextSolution();

}
