/**
 * 
 */
package it.unicam.cs.asdl1819.queens;

import java.util.ArrayList;
import java.util.List;

/**
 * @author luca
 *
 */
public class FirstSolutionEightQueensSolver implements EightQueensSolver {

    // Scacchiera privata di questo solver
    private Scacchiera s;

    // Accumulatore della soluzione
    private List<PositionedQueen> listaRegine;

    /**
     * Crea un nuovo solver
     */
    public FirstSolutionEightQueensSolver() {
        this.s = new Scacchiera();
        this.listaRegine = new ArrayList<PositionedQueen>(); 
    }

    @Override
    public List<PositionedQueen> firstSolution() {
        if (ricerca(s, 0) == false) return null;
        return listaRegine;
    }

    @Override
    public List<PositionedQueen> nextSolution() {
        // TODO Auto-generated method stub
        return null;
    }
    
    private boolean ricerca(Scacchiera s, int col) { 
        if (col >= 8) return true;
        for (int riga = 0; riga < 8; riga++)  { 
            if (s.isFree(riga, col)) { 
                s.putQueen(riga, col);
                PositionedQueen regina = new PositionedQueen(riga, col);
                listaRegine.add(regina);
                if (ricerca(s, col + 1) == true) return true; 
                s.removeQueen(riga, col);
                listaRegine.remove(regina);
            } 
        } 
        return false; 
    } 

}
