/**
 * 
 */
package it.unicam.cs.asdl1819.queens;

import java.util.List;

/**
 * @author Luca Tesei
 *
 */
public class EightQueenTester {

    /**
     * 
     * Lancia un tester per il solver.
     * 
     * @param args
     *                 nessuno
     */
    public static void main(String[] args) {
        EightQueensSolver solver = new AllSolutionsEightQueensSolver();
        List<PositionedQueen> soluzione = solver.firstSolution();
        if (soluzione == null) {
            System.out.println("Prima soluzione nulla!");
            return;
        }
        if (soluzione.size() != 8) {
            System.out.println("Prima soluzione incompleta!");
            return;
        }
        if (!isCorrectSolution(soluzione)) {
            System.out.println("Prima soluzione non corretta!");
            return;
        }

        System.out.println("Prima soluzione corretta:");

        // Stampa la prima soluzione

        int i = 1;
        for (PositionedQueen pq : soluzione) {
            System.out.println("Regina " + i + " Riga: " + pq.getI()
                    + " Colonna: " + pq.getJ());
            i++;
        }

        int contaSoluzioni = 1;
        // Chiede la soluzione successiva
        soluzione = solver.nextSolution();
        
        while (soluzione != null) {
            contaSoluzioni++;
            if (soluzione.size() != 8) {
                System.out.println("Soluzione numero " + contaSoluzioni + " incompleta!");
                return;
            }
            if (!isCorrectSolution(soluzione)) {
                System.out.println("Soluzione numero " + contaSoluzioni + " non corretta!");
                return;
            }
            System.out.println("Soluzione numero " + contaSoluzioni + " corretta:");
            i = 1;
            for (PositionedQueen pq : soluzione) {
                System.out.println("Regina " + i + " Riga: " + pq.getI()
                        + " Colonna: " + pq.getJ());
                i++;
            }
            soluzione = solver.nextSolution();
        }
        System.out.println("Trovate " + contaSoluzioni + " soluzioni.");
    }

    /**
     * Determina se una soluzione, sottoforma di lista di otto regine
     * posizionate, è corretta, cioè le 8 regine sono posizionate in modo da non
     * mangiarsi.
     * 
     * @param solution
     *                     lista di otto regine posizionate
     * @return true se le otto regine sono posizionate correttamente, false
     *         altrimenti
     */
    public static boolean isCorrectSolution(List<PositionedQueen> solution) {
        if (solution == null || solution.size() != 8)
            return false;
        Scacchiera s = new Scacchiera();
        for (PositionedQueen pq : solution) {
            if (s.isFree(pq.getI(), pq.getJ()))
                s.putQueen(pq.getI(), pq.getJ());
            else
                return false;
        }
        return true;
    }
}
