/**
 * 
 */
package it.unicam.cs.asdl1819.queens;

/**
 * 
 * Classe di servizio per rappresentare una scacchiera 8x8 tipica degli scacchi.
 * 
 * @author Luca Tesei
 *
 */
public class Scacchiera {
    private int[][] s;

    /**
     * Inizializza la scacchiera con valori 0
     */
    public Scacchiera() {
        s = new int[8][8];
        for (int i = 0; i < 8; i++)
            for (int j = 1; j < 8; j++)
                s[i][j] = 0;
    }

    /**
     * Inserisce una regina nella scacchiera alla posizione data. Registra nella
     * scacchiera la presenza della regina incrementando di 1 tutte le caselle
     * coperte dalla stessa (inclusa quella in cui si trova).
     * 
     * @param i
     *              riga
     * @param j
     *              colonna
     */
    public void putQueen(int i, int j) {
        // Aumento di 1 la casella in cui si trova la regina
        s[i][j]++;
        // Aumento di 1 tutte le caselle nella riga i tranne quella in cui si
        // trova la regina, cioè la colonna j
        for (int k = 0; k < 8; k++)
            if (k != j)
                s[i][k]++;
        // Aumento di 1 tutte le caselle nella colonna j tranne quella in cui si
        // trova la regina, cioè la riga i
        for (int k = 0; k < 8; k++)
            if (k != i)
                s[k][j]++;
        // Diagonale destra superiore
        int h = 1;
        while ((i - h >= 0) & (j - h >= 0)) {
            s[i - h][j - h]++;
            h++;
        }
        // Diagonale destra inferiore
        h = 1;
        while ((i + h < 8) & (j + h < 8)) {
            s[i + h][j + h]++;
            h++;
        }
        // Diagonale sinistra superiore
        h = 1;
        while ((i - h >= 0) & (j + h < 8)) {
            s[i - h][j + h]++;
            h++;
        }
        // Diagonale sinistra inferiore
        h = 1;
        while ((i + h < 8) & (j - h >= 0)) {
            s[i + h][j - h]++;
            h++;
        }
    }

    /**
     * Toglie una regina dalla scacchiera alla posizione data. Registra nella
     * scacchiera il fatto che la regina non c'è più decrementando di 1 tutte le
     * caselle coperte dalla stessa (inclusa quella in cui si trova).
     * 
     * @param i
     *              riga
     * @param j
     *              colonna
     */
    public void removeQueen(int i, int j) {
     // Decremento di 1 la casella in cui si trova la regina
        s[i][j]--;
        // Decremento di 1 tutte le caselle nella riga i tranne quella in cui si
        // trova la regina, cioè la colonna j
        for (int k = 0; k < 8; k++)
            if (k != j)
                s[i][k]--;
        // Decremento di 1 tutte le caselle nella colonna j tranne quella in cui
        // si
        // trova la regina, cioè la riga i
        for (int k = 0; k < 8; k++)
            if (k != i)
                s[k][j]--;
        // Diagonale destra superiore
        int h = 1;
        while ((i - h >= 0) & (j - h >= 0)) {
            s[i - h][j - h]--;
            h++;
        }
        // Diagonale destra inferiore
        h = 1;
        while ((i + h < 8) & (j + h < 8)) {
            s[i + h][j + h]--;
            h++;
        }
        // Diagonale sinistra superiore
        h = 1;
        while ((i - h >= 0) & (j + h < 8)) {
            s[i - h][j + h]--;
            h++;
        }
        // Diagonale sinistra inferiore
        h = 1;
        while ((i + h < 8) & (j - h >= 0)) {
            s[i + h][j - h]--;
            h++;
        }
    }

    /**
     * Controlla se attualmente una casella della scacchiera è libera, cioè non
     * c'è nessuna regina presente nella casella o non c'è nessun'altra regina
     * nella scacchiera che possa mangiare un eventuale pezzo che si posiziona
     * nella casella.
     * 
     * @param i
     *              riga
     * @param j
     *              colonna
     * @return true se questa casella è libera, false altrimenti.
     */
    public boolean isFree(int i, int j) {
        return s[i][j] == 0;
    }

    // Inserire eventuali altri metodi privati
}
