package it.unicam.cs.asdl1819.bstcomplete;

import java.util.HashSet;

/**
 * Binary Search Tree con classe interna. 
 * @author Luca Tesei
 *
 * @param <E>
 */
public class BSTree<E extends Comparable<E>> {

    // radice dell'albero, se è null, l'albero è vuoto
    private BSTNode root;

    /**
     * Crea un Binary Search Tree vuoto.
     */
    public BSTree() {
        this.root = null;
    }

    /**
     * Crea un Binary Search Tree con radice foglia.
     * 
     * @param rootLabel
     *                      l'informazione associata alla radice
     * @throws NullPointerException
     *                                  se l'elemento è null
     */
    public BSTree(E rootLabel) {
        if (rootLabel == null)
            throw new NullPointerException(
                    "Tentativo di inserire un elemento null");
        this.root = new BSTNode(rootLabel);
    }

    /**
     * Determina l'altezza del BSTree.
     * 
     * @return l'altezza
     */
    public int getHeight() {
        if (this.isEmpty())
            throw new IllegalStateException(
                    "Richiesta dell'altezza di un albero vuoto");
        // l'albero non è vuoto
        // chiamo il metodo ricorsivo sul nodo radice
        return this.root.getHeight();
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    /**
     * Restituisce il successore di una etichetta.
     * 
     * @param label
     * @return l'etichetta successore a label oppure null se il successore non
     *         esiste.
     */
    public E successor(E label) {
        // controllo se è uguale al massimo
        if (label.equals(this.getMaximum()))
            // non c'è successore
            return null;
        // cerco label
        BSTNode labelNode = this.search(label);
        if (labelNode == null) {
            // TODO gestire il caso del successore di un elemento che non esiste
            return null;
        }
        // il nodo esiste
        // cerco il successore
        BSTNode succ = labelNode.successor();
        return succ.label;

    }

    private Object getMaximum() {
        // TODO Auto-generated method stub
        return null;
    }

    private BSTree<E>.BSTNode search(E label) {
        // TODO Auto-generated method stub
        return null;
    }

    public class BSTNode {
        private E label;

        private BSTNode left;

        private BSTNode right;

        private BSTNode parent;

        /**
         * Costruisce un nodo foglia.
         * 
         * @param label
         *                  l'informazione associata al nod
         */
        public BSTNode(E label) {
            this.label = label;
        }

        public int getHeight() {
            // Caso nodo foglia
            if (this.left == null && this.right == null)
                return 0;
            // Caso nodo con un solo figlio
            if (this.left != null && this.right == null)
                return 1 + this.left.getHeight();
            if (this.left == null && this.right != null)
                return 1 + this.right.getHeight();
            // Caso nodo con due figli
            return 1 + Math.max(this.left.getHeight(), this.right.getHeight());
        }

        /**
         * Restituisce il nodo successore di questo nodo. Si suppone che esista
         * un nodo successore.
         * 
         * @return il nodo successore
         */
        public BSTNode successor() {
            BSTNode result = null;
            if (this.right != null)
                // calcolo il minimo del sottoalbero destro
                result = this.right.getMinimum();
            else { // cerco il mio antenato più prossimo
                   // il cui figlio sinistro è
                   // anche un mio antenato
                   // Inizializzo il set degli antenati
                HashSet<BSTNode> antenati = new HashSet<BSTNode>();
                // Siccome supponiamo che il successore esiste e siccome questo
                // nodo non ha un sottoalbero destro allora ne consegue che
                // questo nodo ha un parent, cioè non è la radice
                assert (this.parent != null);
                // inseriamo il parent negli antenat
                antenati.add(this.parent);
                BSTNode currentNode = this;
                // siccome il successore esiste per ipotesi il seguente ciclo
                // prima o poi farà return
                while (true) {
                    BSTNode currentNodeParent = currentNode.parent;
                    if (currentNodeParent.left != null
                            && antenati.contains(currentNodeParent.left)) {
                        // ho trovato il successore
                        return currentNodeParent;
                    }
                    // vado avanti
                    currentNode = currentNodeParent;
                    // aggiorno antenati
                    antenati.add(currentNode.parent);
                }

            }
            return result;
        }

        private BSTree<E>.BSTNode getMinimum() {
            // TODO Auto-generated method stub
            return null;
        }

        /**
         * Costruisce un nodo foglia di un certo genitore.
         * 
         * @param label
         *                   l'informazione associata al nodo
         * @param parent
         *                   il nodo genitore del nuovo nodo foglia
         */
        public BSTNode(E label, BSTNode parent) {
            this.label = label;
            this.parent = parent;
        }

        /**
         * Costruisce un nodo.
         * 
         * @param label
         *                   l'informazione associata al nodo
         * @param left
         *                   il nodo radice del sottoalbero sinistro, null se
         *                   non esiste
         * @param right
         *                   il nodo radice del sottoalbero destro, null se non
         *                   esiste
         * @param parent
         *                   il nodo genitore del nuovo nodo
         */
        public BSTNode(E label, BSTree<E>.BSTNode left, BSTree<E>.BSTNode right,
                BSTree<E>.BSTNode parent) {
            this.label = label;
            this.left = left;
            this.right = right;
            this.parent = parent;
        }

        /**
         * @return the label
         */
        public E getLabel() {
            return label;
        }

        /**
         * @return the left
         */
        public BSTNode getLeft() {
            return left;
        }

        /**
         * @return the right
         */
        public BSTNode getRight() {
            return right;
        }

        /**
         * @return the parent
         */
        public BSTNode getParent() {
            return parent;
        }

        /*
         * (non-Javadoc)
         * 
         * @see java.lang.Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + getOuterType().hashCode();
            result = prime * result + ((label == null) ? 0 : label.hashCode());
            result = prime * result + ((left == null) ? 0 : left.hashCode());
            result = prime * result
                    + ((parent == null) ? 0 : parent.hashCode());
            result = prime * result + ((right == null) ? 0 : right.hashCode());
            return result;
        }

        /*
         * (non-Javadoc)
         * 
         * @see java.lang.Object#equals(java.lang.Object)
         */
        @Override
        public boolean equals(Object obj) {
            if (this == obj)
                return true;
            if (obj == null)
                return false;
            if (!(obj instanceof BSTree.BSTNode))
                return false;
            BSTNode other = (BSTNode) obj;
            if (!getOuterType().equals(other.getOuterType()))
                return false;
            if (label == null) {
                if (other.label != null)
                    return false;
            } else if (!label.equals(other.label))
                return false;
            if (left == null) {
                if (other.left != null)
                    return false;
            } else if (!left.equals(other.left))
                return false;
            if (parent == null) {
                if (other.parent != null)
                    return false;
            } else if (!parent.equals(other.parent))
                return false;
            if (right == null) {
                if (other.right != null)
                    return false;
            } else if (!right.equals(other.right))
                return false;
            return true;
        }

        private BSTree getOuterType() {
            return BSTree.this;
        }

    }
}
