package it.unicam.cs.asdl1819.mylist;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/**
 * Lista concatenata doppia che non accetta valori null, ma permette elementi
 * duplicati.
 * 
 * @author luca
 *
 * @param <E>
 *            il tipo degli elementi della lista
 */
public class MyList<E> implements List<E> {

    private int size;

    private Nodo head;

    private Nodo tail;

    /**
     * Crea una lista vuota.
     */
    public MyList() {
        this.size = 0;
        this.head = null;
        this.tail = null;
    }

    /**
     * Crea un lista con un solo elemento.
     * 
     * @param el
     *               l'elemento della lista
     */
    public MyList(E el) {
        this.size = 1;
        this.head = new Nodo(el);
        this.tail = this.head;

    }

    private class Nodo {
        private E el;

        private Nodo next;

        private Nodo previous;

        /*
         * Crea un nodo "singolo" equivalente a una lista con un solo elemento.
         */
        Nodo(E el) {
            this.el = el;
            this.next = null;
            this.previous = null;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null)
            throw new NullPointerException("Oggetto da cercare nullo!");
        // Ricerca lineare a partire dalla head della lista
        Nodo iPointer = this.head;
        boolean trovato = false;
        while (!trovato && iPointer != null) {
            if (o.equals(iPointer.el))
                trovato = true;
            else
                iPointer = iPointer.next;
        }
        if (trovato)
            return true;
        else
            return false; // equivalente a return trovato;
    }

    @Override
    public Iterator<E> iterator() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public Object[] toArray() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean add(E e) {
        if (e == null)
            throw new NullPointerException(
                    "Tentativo di inserire un elemento null");
        // Creo un nuovo nodo singolo che contiene l'elemento da inserire
        Nodo n = new Nodo(e);
        // aggiorno il next dell'ultimo elemento corrente
        this.tail.next = n;
        // creo il collegamento del nuovo nodo al precedente
        n.previous = this.tail;
        // aggiorno il puntatore alla coda della lista
        this.tail = n;
        // aggioro la size della lista
        this.size++;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c == null)
            throw new NullPointerException(
                    "Tentativo di aggiungere elementi da una collezione null");
        for (Object o : c) {
            if (o == null)
                throw new NullPointerException(
                        "Tentativo di aggiungere un elemento null");
            // non lancio l'eccezione ClassCastException perché uso il metodo
            // contains che accetta comunque qualsiasi oggetto
            if (!this.contains(o))
                return false;
        }
        // tutti gli oggetti della collection appartenevano a questa lista
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public void clear() {
        // TODO Auto-generated method stub

    }

    @Override
    public E get(int index) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public E set(int index, E element) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void add(int index, E element) {
        // controlli con eccezioni
        if (element == null)
            throw new NullPointerException(
                    "Tentativo di inserire un elemento null");
        if (index < 0 || index >= this.size)
            throw new IndexOutOfBoundsException(
                    "Tentativo di accesso alla posizione " + index
                            + " che non esiste nella lista attuale");
        // il caso particolare della lista vuota non è trattato
        // trattiamo il caso di inserimento in testa, cioè index == 0
        if (index == 0) {
            // creo il nuovo nodo
            Nodo n = new Nodo(element);
            // collego il nuovo nodo con il suo successore (ex testa)
            n.next = this.head;
            // collego il vecchio nodo di testa con il suo predecessore (il
            // nuovo nodo)
            this.head.previous = n;
            // aggiorno la testa
            this.head = n;
            // aggiorno la size
            this.size++;
            // esco
            return;
        }
        // decidiamo se partire dalla testa o dalla coda per trovare il
        // puntatore all'elemento in posizione index
        int middle = this.size / 2;
        // inizializzo la variabile risultato
        Nodo scanPointer = null;
        int scanner;
        if (index <= middle) {
            // parto dalla testa
            scanPointer = this.head;
            scanner = 0;
            for (; scanner < index; scanner++)
                scanPointer = scanPointer.next;

        } else {
            // parto dalla coda
            scanPointer = this.tail;
            scanner = this.size - 1;
            for (; scanner > index; scanner--)
                scanPointer = scanPointer.previous;
        }
        // scanPointer punta all'elemento corrente in posizione index
        // creo il puntatore al nodo che viene prima del nuovo nodo da inserire
        Nodo prevPointer = scanPointer.previous;
        // creo il nuovo nodo
        Nodo n = new Nodo(element);
        // collego il nodo precedente (posizione index - 1) al nodo n (nuova
        // posizione index)
        prevPointer.next = n;
        // collego il nuovo nodo con il suo predecessore
        n.previous = prevPointer;
        // collego il nuovo nodo con il suo successore
        n.next = scanPointer;
        // collego il nodo spostato verso sinistra con il suo nuovo predecessore
        // che è il nuovo nodo
        scanPointer.previous = n;
        // aggiorno la size
        this.size++;
    }

    @Override
    public E remove(int index) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null)
            throw new NullPointerException("Oggetto da cercare nullo!");
        // Ricerca lineare a partire dalla head della lista
        Nodo iPointer = this.head;
        int i = -1;
        boolean trovato = false;
        while (!trovato && iPointer != null) {
            i++;
            if (o.equals(iPointer.el))
                trovato = true;
            else
                iPointer = iPointer.next;
        }
        if (trovato)
            return i;
        else
            return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public ListIterator<E> listIterator() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        // TODO Auto-generated method stub
        return null;
    }

}
