package it.unicam.cs.asdl1819.hash;

import static org.junit.Assert.*;

import org.junit.Before;
import org.junit.Test;

public class OpenAddressingHashTableTest {

    @Before
    public void setUp() throws Exception {
    }

    @Test(timeout = 5000, expected = NullPointerException.class)
    public final void testOpenAddressingHashTableNull() {
        OpenAddressingHashTable<String> t = new OpenAddressingHashTable<String>(
                null, new LinearScanOpenAddressingHashFunction(), 47);
    }

    @Test(timeout = 5000, expected = IllegalArgumentException.class)
    public final void testOpenAddressingHashTableNegCapacity() {
        OpenAddressingHashTable<String> t = new OpenAddressingHashTable<String>(
                new DivisionPrimaryHashFunction(),
                new LinearScanOpenAddressingHashFunction(), -47);
    }

    @Test(timeout = 5000)
    public final void testSize() {
        OpenAddressingHashTable<String> t = new OpenAddressingHashTable<String>(
                new DivisionPrimaryHashFunction(),
                new LinearScanOpenAddressingHashFunction(), 47);
        assertEquals(0, t.size());
        t.add("Pippo");
        assertEquals(1, t.size());
        t.add("Pippo");
        assertEquals(1, t.size());
        t.add("Pluto");
        assertEquals(2, t.size());
        t.remove("Pluto");
        assertEquals(1, t.size());
        t.remove("Pippo");
        assertEquals(0, t.size());
    }

    @Test(timeout = 5000)
    public final void testIsEmpty() {
        OpenAddressingHashTable<String> t = new OpenAddressingHashTable<String>(
                new DivisionPrimaryHashFunction(),
                new LinearScanOpenAddressingHashFunction(), 47);
        assertEquals(true, t.isEmpty());
        t.add("Pippo");
        assertEquals(false, t.isEmpty());
    }

    @Test(timeout = 5000)
    public final void testContains() {
        OpenAddressingHashTable<String> t = new OpenAddressingHashTable<String>(
                new DivisionPrimaryHashFunction(),
                new LinearScanOpenAddressingHashFunction(), 47);
        t.add("Pippo");
        assertEquals(true, t.contains("Pippo"));
        assertEquals(false, t.contains("Pluto"));
    }

    @Test
    public final void testAdd() {
        OpenAddressingHashTable<String> t = new OpenAddressingHashTable<String>(
                new DivisionPrimaryHashFunction(),
                new LinearScanOpenAddressingHashFunction(), 3);
        assertEquals(true, t.add("Pippo"));
        assertEquals(false, t.add("Pippo"));
        assertEquals(true, t.contains("Pippo"));
        assertEquals(true, t.add("Pluto"));
        assertEquals(false, t.add("Pluto"));
        assertEquals(true, t.contains("Pluto"));
        assertEquals(true, t.add("Minnie"));
        assertEquals(false, t.add("Minnie"));
        assertEquals(true, t.contains("Minnie"));
    }

    @Test(timeout = 5000, expected = IllegalStateException.class)
    public final void testAddOverCapacity() {
        OpenAddressingHashTable<String> t = new OpenAddressingHashTable<String>(
                new DivisionPrimaryHashFunction(),
                new LinearScanOpenAddressingHashFunction(), 3);
        assertEquals(true, t.add("Pippo"));
        assertEquals(false, t.add("Pippo"));
        assertEquals(true, t.contains("Pippo"));
        assertEquals(true, t.add("Pluto"));
        assertEquals(false, t.add("Pluto"));
        assertEquals(true, t.contains("Pluto"));
        assertEquals(true, t.add("Minnie"));
        assertEquals(false, t.add("Minnie"));
        assertEquals(true, t.contains("Minnie"));
        t.add("Paperino");
    }

    @Test
    public final void testRemove() {
        OpenAddressingHashTable<String> t = new OpenAddressingHashTable<String>(
                new DivisionPrimaryHashFunction(),
                new LinearScanOpenAddressingHashFunction(), 3);
        t.add("Pippo");
        t.add("Pluto");
        t.add("Minnie");
        assertEquals(true, t.remove("Pippo"));
        assertEquals(false, t.remove("Pippo"));
        assertEquals(false, t.contains("Pippo"));
        assertEquals(true, t.remove("Pluto"));
        assertEquals(false, t.remove("Pluto"));
        assertEquals(false, t.contains("Pluto"));
        assertEquals(true, t.remove("Minnie"));
        assertEquals(false, t.remove("Minnie"));
        assertEquals(false, t.contains("Minnie"));
        assertEquals(true,t.isEmpty());
        
    }

}
