package it.unicam.cs.asdl1819.hash;

/**
 * Una classe che implementa questa interfaccia deve fornire una particolare
 * implementazione di una funzione hash che realizza un indirizzamento aperto.
 * 
 * @author Luca Tesei
 *
 */
public interface OpenAddressingHashFunction {

    /**
     * Calcola la posizione di un elemento in una tabella hash con
     * indirizzamento aperto. La funzione calcola la posizione in base a un
     * certo tentativo e utilizza un'altra funzione di hash primaria.
     * 
     * @param h
     *                una funzione di hash primaria
     * @param key
     *                la chiave dell'oggetto da collocare
     * @param m
     *                la dimensione della tabella hash
     * @param i
     *                il tentativo di posizionamento nel processo di inserimento
     *                di tabelle hash con indirizzamento aperto
     * @return un valore compreso tra {@code 0} ed {@code m-1} che corrisponde
     *         alla posizione della chiave passata nella tabella
     */
    public int openHash(PrimaryHashFunction h, int key, int m, int i);

}
