package it.unicam.cs.asdl1819.hash;

/**
 * Una classe che implementa questa interfaccia deve fornire una particolare
 * implementazione di una funzione hash che realizza un hashing doppio con
 * indirizzamento aperto.
 * 
 * @author Luca Tesei
 *
 */
public interface DoubleOpenHashFunction {
    /**
     * Calcola la posizione di un elemento in una tabella hash con un hashing
     * doppio e con indirizzamento aperto. La funzione calcola la posizione in
     * base a un certo tentativo e utilizza due altre funzioni hash primarie.
     * 
     * @param h1
     *                la prima funzione di hash primaria
     * @param h2
     *                la seconda funzione di hash primaria
     * @param key
     *                la chiave dell'oggetto da collocare
     * @param m
     *                la dimensione della tabella hash
     * @param i
     *                il tentativo di posizionamento nel processo di inserimento
     *                di tabelle hash con indirizzamento aperto
     * @return un valore compreso tra {@code 0} ed {@code m-1} che corrisponde
     *         alla posizione della chiave passata nella tabella
     */
    public int openHash(PrimaryHashFunction h1, PrimaryHashFunction h2, int key,
            int m, int i);
}
