package it.unicam.cs.asdl1819.project2;

/**
 * Classe di default per nodi di un grafo che vengono inseriti in code di
 * priorità, tipici negli algoritmi di calcolo dei cammini minimi. La priorità è
 * identificata con la distance floating point del nodo.
 * 
 * @author Luca Tesei
 *
 * @param <V>
 *            etichetta del nodo
 */
public class DefaultPriorityGraphNode<V> extends DefaultGraphNode<V>
        implements PriorityQueueElement {

    public DefaultPriorityGraphNode(V label) {
        super(label);
    }

    @Override
    public double getPriority() {
        return this.getFloatingPointDistance();
    }

    @Override
    public void setPriority(double priority) {
        this.setFloatingPointDistance(priority);

    }

}
