package it.unicam.cs.asdl1819.project2;

import java.util.List;

/**
 * Gli oggetti di questa classe sono calcolatori di cammini minimi con sorgente
 * singola su un certo grafo diretto e pesato dato. Il grafo su cui lavorare
 * deve essere passato quando l'oggetto calcolatore viene costruito e non può
 * contenere archi con pesi negativi. Il calcolatore implementa il classico
 * algoritmo di Dijkstra per i cammini minimi con sorgente singola utilizzando
 * una coda con priorità che estrae il minimo in tempo logaritmico (coda
 * realizzata con uno heap binario). In questo caso il tempo di esecuzione
 * dell'algoritmo di Dijkstra è {@code O(n log m)} dove {@code n} è il numero di
 * nodi del grafo e {@code m} è il numero di archi. Tuttavia, se la coda con
 * priorità è realizzata con uno heap di Fibonacci, si ottiene un tempo di
 * esecuzione {@code O((n log n) + m)}.
 * 
 * @author Luca Tesei
 *
 * @param <V>
 *            il tipo delle etichette dei nodi del grafo
 * @param <E>
 *            il tipo delle etichette degli archi del grafo
 */
public class PriorityQueueDijkstraShortestPathComputer<V extends PriorityQueueElement, E>
        implements SingleSourceShortestPathComputer<V, E> {

    // TODO inserire le variabili istanza necessarie

    /**
     * Crea un calcolatore di cammini minimi a sorgente singola per un grafo
     * diretto e pesato privo di pesi negativi.
     * 
     * @param graph
     *                  il grafo su cui opera il calcolatore di cammini minimi
     * @param queue
     *                  la coda con priorità in cui inserire ed estrarre i nodi
     *                  durante l'esecuzione dell'algoritmo.
     * @throws NullPointerException
     *                                      se il grafo passato è nullo
     * 
     * @throws IllegalArgumentException
     *                                      se il grafo passato è vuoto
     * 
     * @throws IllegalArgumentException
     *                                      se il grafo passato non è diretto
     * 
     * @throws IllegalArgumentException
     *                                      se il grafo passato non è pesato,
     *                                      cioè esiste almeno un arco il cui
     *                                      peso è {@code Double.NaN}.
     * @throws IllegalArgumentException
     *                                      se il grafo passato contiene almeno
     *                                      un peso negativo.
     */
    public PriorityQueueDijkstraShortestPathComputer(Graph<V, E> graph,
            MinPriorityQueue<V> queue) {
        // TODO implementare
    }

    @Override
    public void computeShortestPathsFrom(PriorityGraphNode<V> sourceNode) {
        // TODO implementare

    }

    @Override
    public boolean isComputed() {
        // TODO implementare
        return false;
    }

    @Override
    public PriorityGraphNode<V> getLastSource() {
        // TODO implementare
        return null;
    }

    @Override
    public Graph<V, E> getGraph() {
        // TODO implementare
        return null;
    }

    @Override
    public List<GraphEdge<V, E>> getShortestPathTo(
            PriorityGraphNode<V> targetNode) {
        // TODO implementare
        return null;
    }

    // TODO inserire eventuali altri metodi accessori
}
