/**
 * 
 */
package it.unicam.cs.asdl1819.queens;

import java.util.ArrayList;
import java.util.List;

/**
 * Risolutore del problema delle 8 regine.
 * 
 * @author Luca Tesei
 *
 */
public class EightQueensSolver {

	// Scacchiera privata di questo solver
	private Scacchiera s;

	// TODO Inserire eventuali altre variabili istanza
	private List<PositionedQueen> r;
	int queenRimaste;

	/**
	 * Crea un nuovo solver
	 */
	public EightQueensSolver() {
		s = new Scacchiera();
		r = new ArrayList<PositionedQueen>();
		int previousI;
		int previousJ;
		boolean flag = false;
		queenRimaste = 8;			
		RecSolver(queenRimaste);
		
	}

	/**
	 * Restituisce la prima soluzione trovata tramite la strategia di ricerca con
	 * backtracking.
	 * 
	 * @return la prima soluzione sottoforma di lista di 8 regine posizionate nella
	 *         scacchiera
	 */
	public List<PositionedQueen> firstSolution() {
		return r;
	}

	/**
	 * Restituisce la soluzione successiva all'ultima trovata tramite la strategia
	 * di ricerca con backtracking.
	 * 
	 * @return la prossima soluzione sottoforma di lista di 8 regine posizionate
	 *         nella scacchiera oppure null se non ci sono più soluzioni.
	 */
	public List<PositionedQueen> nextSolution() {
		// TODO implementare
		return null;

	}

	private boolean RecSolver(int queenRimaste) {
		// boolean flagInserimento = false;
		boolean flagPieno = true;
		if (queenRimaste > 0) {
			for (int j = 0; j < 8; j++) {
				for (int i = 0; i < 8; i++) {
					if (s.isFree(i, j)) {
						s.putQueen(i, j);
						r.add(new PositionedQueen(i, j));
						queenRimaste = queenRimaste - 1;
						flagPieno = false;
						// l'elemento successivo non  stato inserito perch il flagPieno suo non 
						// stato disattivato
						if (RecSolver(queenRimaste)) {
							s.removeQueen(i, j);
							r.remove(r.size() - 1);
							queenRimaste = queenRimaste + 1;
							flagPieno = true;
						}
					}
				}

			}
			return flagPieno;
		} else {
			return false;
		}

	}
	
}
