/**
 * 
 */
package it.unicam.cs.asdl1819.queens;

import java.util.*;

/**
 * Risolutore del problema delle 8 regine.
 * 
 * @author Luca Tesei
 *
 */
public class EightQueensSolver {

	// Scacchiera privata di questo solver
	private Scacchiera s;
	private ArrayList<ArrayList<PositionedQueen>> soluzioni;
	private int contatore = 0;
	private int nsol = 0;

	// TODO Inserire eventuali altre variabili istanza

	/**
	 * Crea un nuovo solver
	 */
	public EightQueensSolver() {
		s = new Scacchiera();
		soluzioni = new ArrayList<ArrayList<PositionedQueen>>();
		contatore = 0;
		solver2(0, new ArrayList<PositionedQueen>());
	}

	/**
	 * Restituisce la prima soluzione trovata tramite la strategia di ricerca con
	 * backtracking.
	 * 
	 * @return la prima soluzione sottoforma di lista di 8 regine posizionate nella
	 *         scacchiera
	 */
	public List<PositionedQueen> firstSolution() {
		return nextSolution();
		//return soluzioni.get(0);
	}

	/**
	 * Restituisce la soluzione successiva all'ultima trovata tramite la strategia
	 * di ricerca con backtracking.
	 * 
	 * @return la prossima soluzione sottoforma di lista di 8 regine posizionate
	 *         nella scacchiera oppure null se non ci sono più soluzioni.
	 */
	public List<PositionedQueen> nextSolution() {
		contatore++;
		return soluzioni.get(contatore - 1);
	}
	
	@SuppressWarnings("unchecked")
	private boolean solver2(int col, ArrayList<PositionedQueen> singleSol) {
		if (col == 8) {
			nsol++;
			soluzioni.add(nsol-1,(ArrayList<PositionedQueen>)singleSol.clone());
			return true;
		}

		boolean res = false;
		for (int i = 0; i < 8; i++) {
			if (s.isFree(i, col)) {
				s.putQueen(i, col);
				PositionedQueen regina=new PositionedQueen(i, col);
				singleSol.add(regina);
				res = solver2(col+1, singleSol) || res;
				s.removeQueen(i, col);
				singleSol.remove((Object) regina);
			}
		}

		return res;
	}
}