package it.unicam.cs.asdl1819.project2;

/**
 * Questa interfaccia raggruppa le operazioni di base di una coda con priorità
 * che mantiene in testa l'elemento con priorità minima. Gli elementi sono
 * oggetti di tipo generico le cui classi implementano l'interfaccia
 * {@code PriorityQueueElement}, che offre i metodi per leggere e scrivere la
 * priorità.
 * 
 * @author Luca Tesei
 *
 * @param <E>
 *            il tipo degli elementi che vengono inseriti in coda.
 */
public interface MinPriorityQueue<E extends PriorityQueueElement> {

    /**
     * Determina se questa coda è vuota.
     * 
     * @return true se questa coda è vuota, false altrimenti
     */
    public boolean isEmpty();

    /**
     * Determina il numero di elementi attualmente presenti in questa coda.
     * 
     * @return il numero di elementi attualmente presenti in questa coda
     */
    public int size();

    /**
     * Svuota la coda e la fa diventare vuota.
     * 
     */
    public void clear();

    /**
     * Inserisce un elemento nella coda.
     * 
     * @param element
     *                    l'elemento da inserire
     * 
     * @throws NullPointerException
     *                                  se l'elemento passato è nullo
     */
    public void insert(E element);

    /**
     * Restituisce l'elemento in coda che ha attualmente la priorità associata
     * minima, senza estrarlo dalla coda.
     * 
     * @return l'elemento in coda che ha attualmente la priorità associata
     *         minima
     * 
     * @throws IllegalStateException
     *                                   se la coda è vuota
     */
    public E getMinimum();

    /**
     * Estrae e restituisce l'elemento in coda che ha attualmente la priorità
     * associata minima.
     * 
     * @return l'elemento in coda che ha attualmente la priorità associata
     *         minima
     * 
     * @throws IllegalStateException
     *                                   se la coda è vuota
     * 
     */
    public E extractMinimum();

    /**
     * Decrementa la priorità attualmente associata a un elemento della coda,
     * eventualmente portandolo in testa alla cosa se la nuova priorità è quella
     * minima.
     * 
     * @param element
     *                        elemento di cui modificare la priorità
     * @param newPriority
     *                        nuovo valore della priorità
     * @throws NullPointerException
     *                                      se l'elemento passato è nullo
     * @throws IllegalArgumentException
     *                                      se l'elemento passato non è presente
     *                                      nella coda (non è equals a nessun
     *                                      elemento in coda)
     * 
     */
    public void decreasePriority(E element, double newPriority);

    /**
     * Restituisce il nome di questa coda con priorità.
     * 
     * @return il nome di questa coda con priorità
     */
    public String getName();

}
