/**
 * 
 */
package it.unicam.cs.asdl2021.slides.ereditarieta;

/**
 * Un conto corrente con spese fisse per ogni operazione effettuata.
 * 
 * @author Luca Tesei
 *
 */
public class CheckingAccount extends BankAccount {

    private int numeroOperazioni;

    private double costoPerOperazione;

    /**
     * Costruisce un conto specificando come costo per ogni operazione il valore
     * di default di 1 EUR.
     * 
     * @param saldo
     *                  saldo iniziale
     * @param nome
     *                  nome titolare
     * @param iban
     *                  codice IBAN
     */
    public CheckingAccount(double saldo, String nome, String iban) {
        super(saldo, nome, iban);
        this.costoPerOperazione = 1.0;
        this.numeroOperazioni = 0;
    }

    /**
     * Costruisce un conto specificando il costo per ogni operazione.
     * 
     * @param saldo
     *                               saldo iniziale
     * @param nome
     *                               nome titolare
     * @param iban
     *                               codice IBAN
     * @param costoPerOperazione
     *                               costo di una singola operazione sul conto
     */
    public CheckingAccount(double saldo, String nome, String iban,
            double costoPerOperazione) {
        super(saldo, nome, iban);
        this.costoPerOperazione = costoPerOperazione;
        this.numeroOperazioni = 0;
    }

    /*
     * (non-Javadoc)
     * 
     * @see it.unicam.cs.asdl1617.bankaccounts.BankAccount#endOfMonth()
     */
    @Override
    public void endOfMonth() {
        double costo = this.numeroOperazioni * this.costoPerOperazione;
        System.out.println("Costo " + costo);
        if (this.getSaldo() < costo)
            throw new InsufficientFundForCostException(
                    "SaldoInsufficiente per pagare le spese di operazione");
        super.withdraw(costo);
        this.numeroOperazioni = 0;
    }

    /*
     * Una operazione di deposit va contata per il calcolo delle commissioni.
     * 
     */
    public void deposit(double importo) {
        this.numeroOperazioni++;
        super.deposit(importo);
    }

    /*
     * Una operazione di withdraw va contata per il calcolo delle commissioni.
     */
    public void withdraw(double importo) {
        this.numeroOperazioni++;
        super.withdraw(importo);
    }

}
