/**
 * 
 */
package it.unicam.cs.asdl2021.slides.ereditarieta;

/**
 * Un conto di risparmio con un tasso di interesse.
 * 
 * @author Luca Tesei
 *
 */
public class SavingsAccount extends BankAccount {
    private double interestRate;

    /**
     * Costruisce un conto con un tasso di interesse di default dell 1%.
     * 
     * @param saldo
     *                  saldo iniziale
     * @param nome
     *                  nome titolare
     * @param iban
     *                  codice IBAN
     */
    public SavingsAccount(double saldo, String nome, String iban) {
        super(saldo, nome, iban);
        this.interestRate = 1.0;
    }

    /**
     * Costruisce un conto con un tasso di interesse specifico.
     * 
     * @param saldo
     *                         saldo iniziale
     * @param nome
     *                         nome titolare
     * @param iban
     *                         codice IBAN
     * @param interestRate
     *                         tasso di interesse
     */
    public SavingsAccount(double saldo, String nome, String iban,
            double interestRate) {
        super(saldo, nome, iban);
        this.interestRate = interestRate;
    }

    /*
     * (non-Javadoc)
     * 
     * @see it.unicam.cs.asdl1617.bankaccounts.BankAccount#endOfMonth()
     */
    @Override
    public void endOfMonth() {
        // Si assume per
        // semplicità che nel mese corrente l'importo sia rimasto costante
        // (altrimenti il calcolo degli interessi dovrebbe tener conto degli
        // importi di ogni giorno
        // Il tasso è annuale quindi il tutto va diviso per i 12 mesi
        double interesse = (getSaldo() * interestRate / 100) / 12;
        deposit(interesse);
    }

    /**
     * @return the interestRate
     */
    public double getInterestRate() {
        return interestRate;
    }

    /**
     * @param interestRate
     *                         the interestRate to set
     */
    public void setTassoDiInteresse(double tassoDiInteresse) {
        this.interestRate = tassoDiInteresse;
    }

}
