package it.unicam.cs.asdl2021.slides.interfacceepolimorfismo;

/**
 * Un oggetto conto bancario ha un saldo che pu&ograve; essere modificato da depositi e
 * prelievi.
 */
public class BankAccountSimple {
    
    // Variabile istanza
    private double saldo;

    /**
     * Costruisce un conto bancario con saldo uguale a zero
     */
    public BankAccountSimple() {
        saldo = 0.0;
    }

    /**
     * Costruisce un conto bancario con un saldo assegnato
     * 
     * @param initialBalance
     *            il saldo iniziale
     */
    public BankAccountSimple(double initialBalance) {
        saldo = initialBalance;
    }

    /**
     * Versa denaro nel conto bancario
     * 
     * @param amount
     *            l'importo da versare
     */
    public void deposit(double amount) {
        saldo = saldo + amount;
    }

    /**
     * Preleva denaro dal conto bancario
     * 
     * @param amount
     *            l'importo da prelevare
     */
    public void withdraw(double amount) {
        saldo = saldo - amount;
    }

    /**
     * Ispeziona il valore del saldo attuale del conto bancario
     * 
     * @return il saldo attuale
     */
    public double getBalance() {
        return saldo;
    }

}
