/*******************************************************************************
 * Copyright (c) 2019 Michele Loreti, Università di Camerino.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Contributors:
 *     Michele Loreti - initial API and implementation
 *******************************************************************************/
/**
 * 
 */
package it.unicam.cs.pa.battleship19;

/**
 * <b>Responsabilità</b>: gestire il campo di battaglia.
 * 
 * @author loreti
 *
 */
public interface BattleField {

	/**
	 * Piazza una nave di dimensione <code>size</code> nella posizione <code>shipLocation</code>. 
	 * Restituisce <code>true</code> se l'operazione è riuscita con successo, <code>false</code> 
	 * altrimenti (ad esempio se la nave si sovrappone con altre navi già piazzate o se questa 
	 * <i>esce</i> dal campo di battaglia).
	 * 
	 * @param size dimensione della nave da piazzare
	 * @param shipLocation posizione della nave
	 * @return Restituisce <code>true</code> se l'operazione è riuscita con successo
	 */
	boolean place(int size, ShipLocation shipLocation);

	/**
	 * Verifica se la posizione <code>l</code> è valida.
	 * 
	 * @param l posizione nel campo di battaglia.
	 * @return <code>true</code> se la posizione è valida.
	 */
	boolean isValid(Location l);

	/**
	 * Invocato quando una bomba è lanciata nella posizione <code>l</code>.
	 * 
	 * @param l posizione del lancio
	 * @return effetto del lancio
	 * @throws IllegalLaunchException eccezione sollevata nel caso la posizione sia illegale.
	 */
	LaunchResult launch(Location l) throws IllegalLaunchException;

	/**
	 * Restituisce il numero di navi (non affondate) sul campo di battaglia.
	 * 
	 * @return il numero di navi (non affondate) sul campo di battaglia.
	 */
	int getShips();

}
