/*******************************************************************************
 * Copyright (c) 2019 Michele Loreti, Università di Camerino.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Contributors:
 *     Michele Loreti - initial API and implementation
 *******************************************************************************/
/**
 * 
 */
package it.unicam.cs.pa.battleship19;

/**
 * <b>Responsabilità:</b> Gestione del campo di battaglia (posizionamento delle navi, 
 * 
 * @author loreti
 *
 */
public class FieldManager {
	
	private MatrixBattleField field;
	private LaunchResult[][] attacks;
	private LaunchResult[][] received;

	public FieldManager( int size ) {
		this.field = new MatrixBattleField(size);
		this.attacks = new LaunchResult[size][size];
		this.received = new LaunchResult[size][size];
	}

	public boolean placeShip(int size, ShipLocation loc) {
		return this.field.place(size, loc);
	}


	public void bombAt(Location l) {
		registerLaunchResult(received,field.launch(l));
	}


	private void registerLaunchResult(LaunchResult[][] data, LaunchResult launch) {
		if (launch.getType()!=ResultType.FAIL) {
			for (Location l : launch.getLocs()) {
				data[l.getRow()][l.getColumn()] = launch;
			}
		}
	}

	public void setLaunchResult(LaunchResult r) {
		registerLaunchResult(this.attacks, r);
	}

	public boolean isMyFieldEmpty(Integer i, Integer j) {
		return this.field.isEmpty(i, j);
	}

	public LaunchResult getMyFieldStatus(int i, int j) {
		return this.received[i][j];
	}

	public LaunchResult getOpponentFieldStatus(int i, int j) {
		return this.attacks[i][j];
	}

	public int fieldSize() {
		return this.field.size();
	}


}
