/*******************************************************************************
 * Copyright (c) 2019 Michele Loreti, Università di Camerino.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Contributors:
 *     Michele Loreti - initial API and implementation
 *******************************************************************************/
/**
 * 
 */
package it.unicam.cs.pa.battleship19;

/**
 * <b>Responsabilità</b>: Gestire la strategia di un giocatore. I metodi verranno 
 * invocati secondo il seguente <i>contratto</i>:
 * 
 * <ol>
 * <li> Viengono piazzate le navi usando il metodo {@link #placeShip(int)};
 * <li> Il posizionamento delle navi termina con l'invocazione del metodo {@link #fight()} 
 * che indica l'inizio della battaglia;
 * <li> Quando il giocatore deve effettuare un lancio viene prima invocato il metodo 
 * {@link #launch()} e successivamente il metodo {@link #setResult(LaunchResult)} per notificare
 * al giocatore l'effetto del lancio;
 * <li> Quando il giocatore riceve un attacco, viene invocato il metodo {@link #bomb(Location)};
 * <li> L'invocazione del metodo {@link #win(GameResult)} indica la fine del gioco. 
 * </ol>
 * 
 * La violazione del contratto, ossia una sequenza di invocazioni con un ordine differente, 
 * può generare una {@link IllegalStateException}.
 * 
 * @author loreti
 *
 */
public interface Player {
	

	/**
	 * Questo metodo è invocato per piazzare una nave di dimensione <code>i</code>.
	 * 
	 * @param i dimensione della nave da piazzare
	 * @return posizione della nave
	 */
	ShipLocation placeShip(int i);

	/**
	 * Questo metodo è invocato per notificare al giocatore che è iniziata la battaglia. 
	 */
	void fight();

	/**
	 * Questo metodo è invocato per richiedere la posizione di un lancio.
	 * 
	 * @return la posizione del lancio.
	 */
	Location launch();

	/**
	 * Questo metodo è invocato per notificare il risultato dell'ultimo lancio.
	 * 
	 * @param launch il risultato dell'ultimo lancio.
	 */
	void setResult(LaunchResult launch);
	
	/**
	 * Questo metodo è invocato per notificare il lancio di una bomba da 
	 * parte dell'avversario.
	 * 
	 * @param l posizione del lancio.
	 */
	void bomb(Location l);

	/**
	 * Questo metodo è invocato per notificare la fine del gioco. 
	 * 
	 * @param flag risultato del gioco.
	 * @param result risultato del gioco.
	 */
	void end( boolean flag, GameResult result );
	

}
