/*******************************************************************************
 * Copyright (c) 2019 Michele Loreti, Università di Camerino.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Contributors:
 *     Michele Loreti - initial API and implementation
 *******************************************************************************/
/**
 * 
 */
package it.unicam.cs.pa.battleship19;

/**
 * <b>Responsabilità:</b> Definisce le funzionalità messe a disposizione 
 * da una <i>vista</i> per la battaglia navale.
 * 
 * @author loreti
 *
 */
public interface BattleShipView {
	
	/**
	 * Chiede all'utente la posizione di una nave di dimensione <code>size</code>.
	 * 
	 * @param size dimensione della nave
	 * 
	 * @return posizione dove piazzare la nave
	 */
	ShipLocation placeShip(int size);

	/**
	 * Chiede all'utente la posizione dove lanciare una bomba.
	 * 
	 * @return posizione dove lanciare una bomba.
	 */
	Location launch();

	/**
	 * Imposta i parametri di gioco.
	 * 
	 * @param parameters i parametri di gioco.
	 */
	void setParameters(GameParameters parameters);

	/**
	 * Inizia il combattimento dopo aver posizionato le navi.
	 */
	void fight();

	/**
	 * Notifica alla vista la fine del gioco.
	 * 
	 * @param winFlag true se la partita è vinta.
	 * @param result risultato della partita (motivo della vittoria/sconfitta).
	 */
	void end(boolean winFlag, GameResult result);

	/**
	 * Aggiorna la vista a seguito di una bomba lanciata nella posizione l.
	 * 
	 * @param l posizione della bomba.
	 */
	void bombAt(Location l);

	/**
	 * Aggiorna la vista con il risultato dell'ultimo lancio.
	 *  
	 * @param r risultato dell'ultimo lancio.
	 */
	void setLaunchResult(LaunchResult r);	
	
}
