/*******************************************************************************
 * Copyright (c) 2019 Michele Loreti, Università di Camerino.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Contributors:
 *     Michele Loreti - initial API and implementation
 *******************************************************************************/
/**
 * 
 */
package it.unicam.cs.pa.battleship19;

/**
 * Gestisce i parametri di una partita.
 * 
 * @author loreti
 *
 */
public class GameParameters {

	/**
	 * Parametri di default.
	 */
	public static final GameParameters DEFAULT_PARAMETERS = new GameParameters( 10 , 5 , 4 , 3 , 3  , 2 );
	
	/**
	 * Dimenzione del campo di battaglia.
	 */
	private final int size;
	
	/**
	 * Array contenente la composizione della flotta. Nella posizione <code>i</code>
	 * dell'array è memorizzato il numero delle navi di dimensione <code>i+1</code>.
	 */
	private final int[] fleet;
	
	/**
	 * Definisce i parametri di gioco con un campo di dimensione <code>size</code> e
	 * flotta <code>fleet</code>.
	 * 
	 * @param size dimensione del campo di battaglia
	 * @param fleet composizione della flotta.
	 */
	public GameParameters( int size , int ... fleet ) {
		this.size = size;
		this.fleet = fleet;
	}

	/**
	 * Restituisce la dimensione del campo di battaglia.
	 * 
	 * @return dimensione del campo di battaglia.
	 */
	public int getSize() {
		return size;
	}

	/**
	 * Restituisce la composizione della flotta.
	 * 
	 * @return la composizione della flotta.
	 */
	public int[] getFleet() {
		return fleet;
	}
	
	/**
	 * Restituisce il numero di imbarcazioni di dimensione <code>l</code>.
	 * 
	 * @param l dimensione
	 * @return Numero di imbarcazioni di dimensione <code>l</code>.
	 */
	public int numberOf( int l ) {
		if ((fleet.length>l)||(l<=0)) {
			return 0;
		}
		return fleet[l-1];
	}
	
	/**
	 * Restituisce la dimensione massima delle navi. 
	 * 
	 * @return la dimensione massima delle navi. 
	 */
	public int maxShipLength() {
		return fleet.length;
	}
	
	
}
