/*******************************************************************************
 * Copyright (c) 2019 Michele Loreti, Università di Camerino.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Contributors:
 *     Michele Loreti - initial API and implementation
 *******************************************************************************/
/**
 * 
 */
package it.unicam.cs.pa.battleship19;

/**
 * <b>Responsabilità:</b> Identificare la posizione in un campo di battaglia.
 * 
 * @author loreti
 *
 */
public class Location {

	/**
	 * Riga.
	 */
	private final int row;
	
	/**
	 * Colonna.
	 */
	private final int column;
	
	/**
	 * Crea una posizione alla specifica riga/colonna.
	 * 
	 * @param row riga
	 * @param column colonna
	 */
	public Location( int row , int column ) {
		this.row = row;
		this.column = column;
	}
	
	/**
	 * Restituisce la riga della cella.
	 * 
	 * @return la riga della cella.
	 */
	public int getRow() {
		return row;
	}

	/**
	 * Restituisce la colonna della cella.
	 *
	 * @return la colonna della cella
	 */
	public int getColumn() {
		return column;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + column;
		result = prime * result + row;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Location other = (Location) obj;
		if (column != other.column)
			return false;
		if (row != other.row)
			return false;
		return true;
	}

	@Override
	public String toString() {
		return "[row=" + row + ", column=" + column + "]";
	}

}
