/*******************************************************************************
 * Copyright (c) 2019 Michele Loreti, Università di Camerino.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Contributors:
 *     Michele Loreti - initial API and implementation
 *******************************************************************************/
/**
 * 
 */
package it.unicam.cs.pa.battleship19;

/**
 * <b>Responsabilità:</b> gestione di un giocatore interattivo. Il giocatore
 * astrae rispetto ad una specifica interfaccia. 
 * 
 * @author loreti
 *
 */
public class InteractivePlayer implements Player {

	/**
	 * Sorgente da dove recuperare le informazioni.
	 */
	private BattleShipView view;
	
	private Location lastLaunch;
		
	public InteractivePlayer( GameParameters parameters, BattleShipView input ) {
		this.view = input;
		this.view.setParameters(parameters);
	}

	@Override
	public Location launch() {
		this.lastLaunch = view.launch();
		return this.lastLaunch;
	}

	@Override
	public void setResult(LaunchResult r) {
		this.view.setLaunchResult(r);
	}

	@Override
	public void bomb(Location l) {
		this.view.bombAt(l);
	}


	@Override
	public ShipLocation placeShip(int size) {
		return this.view.placeShip(size);
	}
	
	@Override
	public void fight() {
		this.view.fight();
	}

	@Override
	public void end(boolean winFlag, GameResult result) {
		this.view.end(winFlag,result);
	}
}
