/*******************************************************************************
 * Copyright (c) 2019 Michele Loreti, Università di Camerino.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Contributors:
 *     Michele Loreti - initial API and implementation
 *******************************************************************************/
/**
 * 
 */
package it.unicam.cs.pa.battleship19;

import java.util.Random;

/**
 * Giocatore random. Questo giocatore seleziona le posizioni delle navi e 
 * le posizione dei lanci in modo "random".
 * 
 * @author loreti
 *
 */
public class RandomPlayer implements Player {
	
	private FieldManager manager;
	
	private Random random;
	private Location[] locations;
	private int counter;
	private int size;
	
	public RandomPlayer( Random random , int size) {
		this.random = random;
		this.size = size;
		generateLocations();
		this.counter = 0;
		this.manager = new FieldManager(size);
	}

	private void generateLocations() {
		int counter = 0;
		locations = new Location[size*size];
		for( int i=0 ; i<size ; i++ ) {
			for( int j=0 ; j<size; j++ ) {
				locations[counter++] = new Location(i,j);
			}
		}
	}
	
	private Location nextLocation() {
		int idx = random.nextInt(locations.length-counter)+counter;
		Location l = locations[idx];
		locations[idx] = locations[counter];
		locations[(counter++)] = l;
		return l;
	}

	@Override
	public ShipLocation placeShip(int size) {
		while (true) {
			Location l = new Location(random.nextInt(manager.fieldSize()), random.nextInt(manager.fieldSize()));
			Direction d = (random.nextDouble()<0.5?Direction.HORIZONTAL:Direction.VERTICAL);
			ShipLocation sl = new ShipLocation(l, d);
			if (manager.placeShip(size, sl)) {
				return sl;
			}
		}
	}

	@Override
	public void fight() {
	}

	@Override
	public Location launch() {
		while (true) {
			Location l = nextLocation() ;
			if (manager.getOpponentFieldStatus(l.getRow(), l.getColumn())==null) {
				return l;
			}
		}
	}

	@Override
	public void setResult(LaunchResult launch) {
		manager.setLaunchResult(launch);
	}

	@Override
	public void bomb(Location l) {
		manager.bombAt(l);
	}

	@Override
	public void end(boolean flag, GameResult result) {
	}

}
