/**
 * 
 */
package it.unicam.cs.pa.battleship19;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;


/**
 * @author loreti
 *
 */
public class PlayerRegistry {

	private static PlayerRegistry instance;
	private Map<String,PlayerFactory> registry;
	
	private PlayerRegistry() {
		this.registry = new HashMap<String, PlayerFactory>();
		init();
	}
	
	

	private void init() {
		register("bot", new RandomPlayerFactory());
		register("simple", new SimplePlayerFactory());
		register("interactive", new InteractivePlayerFactory());		
	}



	public static PlayerRegistry getInstance() {
		if (instance == null) {
			instance = new PlayerRegistry();
		}
		return instance;
	}

	public PlayerFactory getPlayer(String name) {
		return registry.get(name);
	}

	public void register( String name , PlayerFactory factory ) {
		this.registry.put(name, factory);	
	}
	
	private void register( int i, String registryLine ) {
		try {
			String[] elements = registryLine.split(" ");		
			if (elements.length == 2) {
				register( elements[0], elements[1] );
				return ;
			} 
			throw new RegistrySyntaxException("Syntax error: wrong number of elements!");
		} catch (Exception e) {
			Logger.getGlobal().severe("Syntax error: "+e.getLocalizedMessage());
		}
	}
	
	public void register( String name, String className ) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
		Class<? extends PlayerFactory> clazz = Class.forName(className).asSubclass(PlayerFactory.class);
		this.register(name,  clazz.getConstructor().newInstance() );
	}
	
	public void load( File f ) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
		List<String> data = Files.readAllLines(f.toPath(), Charset.defaultCharset());
		AtomicInteger c = new AtomicInteger(1);
		data.stream()
			.forEach(l -> this.register( c.getAndIncrement() , l ));
	}
	
}
