/**
 * 
 */
package it.unicam.cs.pa.battleship19;

/**
 * @author loreti
 *
 */
public class SimplePlayer implements Player {
	
	private final FieldManager manager;
	private int size;
	
	private int lastColumn = 0;
	private int lastRow = 0;
	
	public SimplePlayer(GameParameters parameters) {
		this.size = parameters.getSize();
		this.manager = new FieldManager(size);
	}

	@Override
	public ShipLocation placeShip(int i) {
		ShipLocation sl;
		do {
			sl = new ShipLocation(getNextLocation(), Direction.HORIZONTAL);			
		} while (!this.manager.placeShip(i, sl));
	
		return sl;
	}

	private Location getNextLocation() {
		Location l = new Location(lastRow, lastColumn);
		lastColumn++;
		if (lastColumn>=size) {
			lastRow++;
			lastColumn=0;
		}
		return l;
	}

	@Override
	public void fight() {
		this.lastRow = 0;
		this.lastColumn = 0;
	}

	@Override
	public Location launch() {
		return getNextLocation();
	}

	@Override
	public void setResult(LaunchResult launch) {
		this.manager.setLaunchResult(launch);
	}

	@Override
	public void bomb(Location l) {
		this.manager.bombAt(l);
	}

	@Override
	public void end(boolean flag, GameResult result) {
	}

}
