/*******************************************************************************
 * Copyright (c) 2019 Michele Loreti, Università di Camerino.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Contributors:
 *     Michele Loreti - initial API and implementation
 *******************************************************************************/
/**
 * 
 */
package it.unicam.cs.pa.battleship19;

/**
 * <b>Responsabilità</code>: Definisce le possibili direzioni di una nave.
 * 
 * @author loreti
 *
 */
public enum Direction {
	
	HORIZONTAL,
	VERTICAL;

	/**
	 * Data una locazione determina, a seconda della direzione, la locazione successiva.
	 * 
	 * @param l una posizione sul campo di battaglia.
	 * 
	 * @return la posizione successiva nella direzione.
	 * 
	 */
	public Location next(Location l) {
		if (this==HORIZONTAL) {
			return new Location(l.getRow(),l.getColumn()+1);
		} else {
			return new Location(l.getRow()+1,l.getColumn());
		}
	}

	public Location[] getLocations(Location location, int size) {
		Location[] toReturn = new Location[size];
		Location l = location;
		for( int i=0 ; i<size ; i++ ) {
			toReturn[i] = l;
			l = next(l);
		}
		return toReturn;
	}

}
