/*******************************************************************************
 * Copyright (c) 2019 Michele Loreti, Università di Camerino.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Contributors:
 *     Michele Loreti - initial API and implementation
 *******************************************************************************/
/**
 * 
 */
package it.unicam.cs.pa.battleship19;

/**
 * <b>Responsabilità:</b> Gestire il risultato di un lancio.
 * 
 * @author loreti
 *
 */
public class LaunchResult {

	/**
	 * Tipo del risultato.
	 */
	private ResultType type;

	/**
	 * Locazioni coinvolte nel lancio. 
	 */
	private Location[] locs;
	
	/**
	 * Crea un risultato di tipo <code>type</code> con efetto sulle locazioni <code>locs</code>.
	 * 
	 * @param type tipo del risultato 
	 * @param locs locazioni coinvolte
	 */
	public LaunchResult( ResultType type, Location ... locs ) {
		this.type = type;
		this.locs = locs;
	}

	/**
	 * Restituisce il tipo del risultato.
	 * 
	 * @return il tipo del risultato
	 */
	public ResultType getType() {
		return type;
	}

	/**
	 * Restituisce le locazioni coinvolte
	 * 
	 * @return le locazioni coinvolte
	 */
	public Location[] getLocs() {
		return locs;
	}

	
}
