/*******************************************************************************
 * Copyright (c) 2019 Michele Loreti, Università di Camerino.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Contributors:
 *     Michele Loreti - initial API and implementation
 *******************************************************************************/
package it.unicam.cs.pa.battleship19;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Random;
import java.util.logging.Logger;

/**
 * @author loreti
 *
 */
public class ConsoleGame {
	
	private PrintStream output;	
	private BufferedReader input;
	private PlayerFactory playerFactory1;
	private PlayerFactory playerFactory2;
	private Logger logger = Logger.getGlobal();
	private Random random;
	
	public ConsoleGame( 			
			PlayerFactory playerFactory1,
			PlayerFactory playerFactory2
	) {
		this(new BufferedReader(new InputStreamReader(System.in)),System.out,playerFactory1,playerFactory2,new Random());
	}
	
	public ConsoleGame(BufferedReader input, 
			PrintStream output,
			PlayerFactory playerFactory1,
			PlayerFactory playerFactory2,
			long seed
			) {
		this(input,output,playerFactory1,playerFactory2,new Random(seed));
	}

	public ConsoleGame(BufferedReader input, 
			PrintStream output,
			PlayerFactory playerFactory1,
			PlayerFactory playerFactory2,
			Random random
			) {
		this.input = input;
		this.output = output;
		this.playerFactory1 = playerFactory1;
		this.playerFactory2 = playerFactory2;
		this.random = random;
	}

	public static void main(String[] argv) throws IOException {
		Logger.getGlobal().info("Application started...");
		if (argv.length!=2) {
			System.err.println("ConsoleGame <player1> <player2>\nUsa \"bot\" per un giocatore random...");
		} else {
			new ConsoleGame(PlayerRegistry.getInstance().getPlayer(argv[0]),PlayerRegistry.getInstance().getPlayer(argv[1])).start();			
		}
	}

	private void start() throws IOException {
		do {
			logger.info("New match started...");
			MatchCoordinator mc = new MatchCoordinator(
					p -> new MatrixBattleField(p.getSize()) , 
					GameParameters.DEFAULT_PARAMETERS, 
					p -> playerFactory1.createPlayer(0, p, new ConsoleView("player1", output, input), random), 
					p -> playerFactory2.createPlayer(1, p, new ConsoleView("player2", output, input), random)
			);			
			System.out.println(mc.play());
		} while (matchAgain());
	}

	private  boolean matchAgain() throws IOException {
		while (true) {
			output.println("Vuoi combattere ancora? (S/N)");
			String str = input.readLine();
			if (str.equals("N")) {
				output.println("Arrivederci...");
				return false;
			}
			if (str.equals("S")) {
				output.println("Pronti per una nuova battaglia!");
				return true;
			}
			output.println("Inserisci S o N!");
		}
	}

}
