package it.unicam.cs.pa.battleship19.tests;

import static org.junit.jupiter.api.Assertions.*;

import org.junit.jupiter.api.Test;

import it.unicam.cs.pa.battleship19.BattleField;
import it.unicam.cs.pa.battleship19.IllegalLaunchException;
import it.unicam.cs.pa.battleship19.Location;
import it.unicam.cs.pa.battleship19.MatrixBattleField;
import static java.time.Duration.ofSeconds;

class MatrixBattleFieldTest {

	@Test
	void shouldBeValid() {
		int size = 10;
		MatrixBattleField field = new MatrixBattleField(size);
		for( int i=0 ; i<size ; i++ ) {
			for( int j=0 ; j<size ; j++ ) {
				assertTrue( field.isValid(new Location(i, j)));
			}
		}
	}
	
	@Test
	void shouldThrowException() {
		int size = 10;
		BattleField field = new MatrixBattleField(size);
		IllegalLaunchException exception =  assertThrows(IllegalLaunchException.class ,  
				() -> field.launch(new Location(size+1,size+1)));
		assertEquals("Illegal location",exception.getMessage());
	}
	

}
