/**
 * 
 */
package it.unicam.cs.pa.bstree2;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.BiFunction;


/**
 * @author loreti
 *
 */
public interface BSTree<T extends Comparable<T>> {
	
	public BSTree<T> add( T value );
	public BSTree<T> remove( T value );
	
	default BSTree<T> addAll( Collection<? extends T> values ) {
		BSTree<T> tree = this;
		for (T v : values) {
			tree = tree.add(v);
		}
		return tree;
	}
	
	public boolean find( T value );
	
	public boolean isBalanced( );
	
	public int getBalanceLevel();
	
	public int size();
	
	public int getHeight();
	
	public boolean isEmpty();
	
	public void print();
	
	public Iterator<T> getIterator( boolean ascending );
	
	public <R> R reduce( BiFunction<T, R, R> f , R init , boolean ascending );
}
