/**
 * 
 */
package it.unicam.cs.pa.bstree2;

import java.util.Iterator;
import java.util.function.BiFunction;

/**
 * @author loreti
 *
 */
public class EmptyBStree<T extends Comparable<T>> implements BSTree<T> {

	@Override
	public BSTree<T> add(T value) {
		return new BSTreeNode<T>(value);
	}

	@Override
	public BSTree<T> remove(T value) {
		return this;
	}

	@Override
	public boolean find(T value) {
		return false;
	}

	@Override
	public boolean isBalanced() {
		return true;
	}

	@Override
	public int getBalanceLevel() {
		return 0;
	}

	@Override
	public int size() {
		return 0;
	}

	@Override
	public int getHeight() {
		return 0;
	}

	@Override
	public boolean isEmpty() {
		return true;
	}

	@Override
	public void print() {
		System.out.println("");
	}

	@Override
	public Iterator<T> getIterator(boolean ascending) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public <R> R reduce(BiFunction<T, R, R> f, R init, boolean ascending) {
		return init;
	}

}
