/**
 * 
 */
package it.unicam.cs.pa.bstree2;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiFunction;

/**
 * @author loreti
 *
 */
public class BSTreeNode<T extends Comparable<T>> implements BSTree<T> {

	private final T root;
	private final BSTree<T> left;
	private final BSTree<T> right;

	/**
	 * Create a new BSTree containing the single value <code>value</code>. 
	 * If <code>value</code> is <code>null</code> a <code>NullPointerException</code>
	 * is generated.
	 * 
	 * @param value the single value in the created tree.
	 * @throw NullPointerException if <code>value</code> is null.
	 */
	public BSTreeNode(T value) {
		this(value, new EmptyBStree<>(), new EmptyBStree<>());
	}

	private BSTreeNode(T value, BSTree<T> left, BSTree<T> right) {
		Objects.requireNonNull(value);
		this.root = value;
		this.left = left;
		this.right = right;
	}

	@Override
	public BSTree<T> add(T value) {
		int c = this.root.compareTo(value);
		BSTree<T> newRight = (c<=0?this.right.add(value):this.right); 
		BSTree<T> newLeft = (c>0?this.left.add(value):this.left);
		return new BSTreeNode<T>( this.root , newLeft, newRight);
	}

	@Override
	public BSTree<T> remove(T value) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean find(T value) {
		int c = this.root.compareTo(value);
		if (c==0) {
			return true;
		} else {
			return (c<0?this.right.find(value):this.left.find(value));
		}
	}

	@Override
	public boolean isBalanced() {
		return left.isBalanced()
				&&right.isBalanced()
				&&(Math.abs(getBalanceLevel())<=1);
	}

	@Override
	public int getBalanceLevel() {
		return left.getHeight()-right.getHeight();
	}

	@Override
	public int size() {
		return 1+left.size()+right.size();
	}

	@Override
	public int getHeight() {
		return 1+Math.max(left.getHeight(), right.getHeight());
	}

	@Override
	public boolean isEmpty() {
		return false;
	}

	@Override
	public void print() {
		this.left.print();
		System.out.println(this.root);
		this.right.print();
	}
	

	@Override
	public Iterator<T> getIterator(boolean ascending) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public <R> R reduce(BiFunction<T, R, R> f, R init, boolean ascending) {
		BSTree<T> first = (ascending?this.left:this.right);
		BSTree<T> second = (!ascending?this.right:this.left);
		return second.reduce( f , 
				f.apply(this.root, first.reduce(f, init, ascending)), 
				ascending);
		
//		R reduce1 = (ascending?
//						this.left.reduce(f, init, ascending):
//						this.right.reduce(f, init, ascending));
//		R reduce2 = f.apply(this.root, reduce1);
//		return (!ascending?
//				this.left.reduce(f, reduce2, ascending):
//				this.right.reduce(f, reduce2, ascending));
//		if (ascending) {
//			return this.right.reduce(f, 
//						f.apply( this.root, 
//								this.left.reduce(f, init, ascending)
//						), 
//						ascending
//			);
//		} else {
//			return this.left.reduce(f, 
//					f.apply( this.root, 
//							this.right.reduce(f, init, ascending)
//					), 
//					ascending
//		);
//		}
	}

}
