public class ArrayRicerca {

    public static void main(String[] args)
    {
        ArrayRicerca ar = new ArrayRicerca();
        int[] a = {7, 11, 22, 33, 45, 63, 88, 99};
        int[] b = {1, 1, 2, 1, 2, 1, 3, 2, 1};
        
        int cercaRis = ar.cercaVal(a, 33);
        System.out.println("cercaRis: " + cercaRis);
        
        int contaRis = ar.contaVal(b, 1);
        System.out.println("contaRis: " + contaRis);
    }
    
    
    //Restituisce la prima posizione dell'elemento val nell'array arr 
    public int cercaVal(int[] arr, int val)
    {
        int pos = 0;
        boolean trovato = false;    
        int i = 0;
        //si utilizza la ricerca con successo: si scorre tutto l'array finchè
        //  o si trova l'elemento cercato,
        //  oppure si è arrivato alla fine dell'array
        //si usa il ciclo while perchè non si sa a priori quando la ricerca termina
        while(!trovato && i < arr.length) {
            //se si trova l'elemento cercato, si salva la sua posizione 
            //e si imposta la variabile per terminare il ciclo
            if(arr[i] == val) {
                pos = i;
                trovato = true;
            }
            i++;
        }
        return pos;
    }
    
    //Restituisce il numero di volte che l'elemento val compare nell'array arr 
    public int contaVal(int[] arr, int val)
    {
        int cont = 0;
        //si scorre tutto l'array e si contano le occorrenze dell'elemento cercato
        //si usa il ciclo for perchè si sa a priori che si deve scorrere tutto l'array
        for(int i = 0; i < arr.length; i++) {
            if(arr[i] == val)
                cont ++;
        }
        return cont;
    }
}