public class SelectionSort {

    public static void main(String[] args)
    {
        SelectionSort ss = new SelectionSort();
        //int[] a = {45, 88, 22, 63, 11, 33, 99, 7};
        int[] a = {8, 5, 2, 6, 9, 3, 1, 4, 0, 7};
        
        ss.printArray(a, "a");
        ss.selectionSort(a);
        ss.printArray(a, "a[] dopo selectionSort");
    }
    
    //selection sort: ordina un array tramite iterazioni successive
    //ogni iterazione posiziona l'elemento più piccolo 
    public void selectionSort(int a[])
    {
        int scambio;
        //freccia grande: serve per puntare alla posizione dell'array in cui mettere il vaore più piccolo
        //una volta conclusa l'iterazione, contiene l'elemento ordinato e si incrementa
        for(int i = 0; i < a.length -1; i++)
        {
            int pos = i;    //variabile che contine la posizione dell'elemento più piccolo per questa iterazione
            
            //ciclo che parte dalla posizione successiva alla freccia grande (dato che le precedenti sono ordinate)
            //e scansiona l'array cercando l'elemento più piccolo
            for(int j = i+1; j < a.length; j++) {
                if(a[j] < a[pos]) {
                    pos = j;
                }
            }
            //se pos != i significa che è stato trovato un elemento più piccolo di quello attualmente presente
            //si deve procedere allo scambio dei due elementi
            if(pos != i) {
                scambio = a[pos];
                a[pos] = a[i];
                a[i] = scambio;
            }
            System.out.print("iterazione " + i + ": ");
            printArray(a, "a", 0, a.length -1);
        }
    }
    
    public void printArray(int[] arr, String name, int start, int end)
    {
        System.out.print(name + "[" + start + ", " + end + "] = {");
        if(arr.length > 0) {
            for(int i = start; i < end; i++)
                System.out.print(arr[i] + ", ");
            System.out.print(arr[end]);
        }
        System.out.println("}");
    }
    
    public void printArray(int[] arr, String name)
    {
        printArray(arr, name, 0, arr.length-1);
    }
}
