public class ArrayMedia {

    public static void main(String args[])
    {
        ArrayMedia am = new ArrayMedia();
        
        //calcolo della media aritmetica
        double[] mediaAritArr = {1, 2, 2, 4, 5, 3, 3, 3};
        double mediaArit = am.mediaAritmeica(mediaAritArr);
        System.out.println("media aritmetica: " + mediaArit);
        
        //moda
        int[] modaArr = {2, 1, 2, 3, 4, 3, 5, 3};
        int moda = am.moda(modaArr);
        System.out.println("moda: " + modaArr[moda] + ", pos: " + moda);
        
        //mediana
        int[] medianaArr = {1, 2, 7, 8, 9, 11};
        double mediana = am.mediana(medianaArr);
        System.out.println("mediana: " + mediana);
    }

    //metodo che calcola la media aritmetica di un array
    private double mediaAritmeica(double[] arr) {
        double somma = 0;
        //ciclo che scorre tutto l'array e calcola la somma di tutti gli elementi
        for(int i = 0; i < arr.length; i++)
            somma += arr[i];
        //si calcola la media dividendo la somma per il numero degli elementi
        somma = somma / arr.length;
        return somma;
    }
    
    //metodo che calcola la moda di un array, cioè l'elemento che appare più volte
    public int moda(int[] arr) {
        int modaPos = 0;        //posizione dell'elemento moda nell'array
        int modaCont = 0;       //numero di volte che l'elemento moda compare
        
        //ciclo for che scorre tutti gli elementi dell'array
        for(int i = 0; i < arr.length; i++) {
            int cont = 0;       //contatore per l'elemento dell'array considerato
            
            //per ogni elemento, si contano quante volte quell'elemento appare nell'array
            for(int j = 0; j < arr.length; j++) {
                if(arr[j] == arr[i])
                    cont ++;
            }
            
            //se l'elemento appare più volte della vecchia moda, allora diventa la nuova moda
            if (modaCont < cont) {
                modaPos = i;        //la posizione è ora la posizione dell'elemento
                modaCont = cont;   //il numero di volte che compare è ora il contatore dell'elemento
            }
        }
        //infine si restituisce la posizione trovata
        return modaPos;
    }
    
    
    //metodo che calcola la mediana di un array. L'array deve essere ordinato crescentemente.
    //se l'array un numero di elementi dispari, la mediana è l'elemento centrale;
    //se l'array un numero di elementi pari, la mediana è la media aritmetica dei due elementi centrali
    public double mediana(int[] array) {
        double mediana = 0;
        
        if(array.length % 2 == 0) //array pari
        {
            //si calcola la media aritmetica tra i valori centrali
            int num1 = array[array.length / 2 -1];  //-1 per prendere il primo delgi elementi centrali
            int num2 = array[(array.length / 2)];
            mediana = (double) (num1 + num2) / 2;
        }
        else            //array dispari
        {
            //si seleziona l'unico elemento centrale
            mediana = array[array.length / 2];
        }
        //si restituisce il valore della mediana
        return mediana;
    }
    
    //metodo che stampa un array da una posizione di partenza a una di fine, estremi compresi
    public void printArray(int[] arr, String name, int start, int end)
    {
        System.out.print(name + "[" + start + ", " + end + "] = {");
        if(arr.length > 0) {
            for(int i = 0; i < arr.length-1; i++)
                System.out.print(arr[i] + ", ");
            System.out.print(arr[arr.length-1]);
        }
        System.out.println("}");
    }
}
